
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.dialogues;


import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.event.*;
import javax.swing.*;

import phex.*;
import phex.download.*;


public class DlgAddAsCandidate extends JDialog implements KeyListener
{
    private BaseFrame			mFrame;
    private JList				mList;
    private boolean				mCancel;
    private Vector				mDownloads = new Vector();
    private DownloadFile		mDownloadFile = null;

    public DlgAddAsCandidate(BaseFrame frame, RemoteFile rfileToAdd)
    {
        super(frame, true);
        mFrame = frame;

        DownloadManager dm = ServiceManager.getDownloadManager();
        for (int i = 0; i < dm.getDownloadCount(); i++)
        {
            DownloadFile download = dm.getDownloadFileAt( i );
            if ( download == null )
            {
                continue;
            }
            if ( rfileToAdd.getFileSize() == download.getTotalFileSize() )
            {
                mDownloads.addElement(download);
            }
        }

        setTitle("Add as Download Candidate");
        setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);

        JPanel		descPanel = new JPanel(new BorderLayout());
        descPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        descPanel.add(BorderLayout.CENTER, new JLabel("Select a download file to add the remote file as its download candidate"));


        // Center panel for holding the fields
        JPanel		centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                    BorderFactory.createEmptyBorder(20, 20, 20, 20),
                    BorderFactory.createEtchedBorder()),
                BorderFactory.createEmptyBorder(16, 20, 20, 20)));

        mList = new JList(mDownloads);
        centerPanel.add(BorderLayout.NORTH, new JLabel("Current Matching Download:"));
        centerPanel.add(BorderLayout.CENTER, new JScrollPane(mList));
        mList.setPreferredSize(new Dimension(320, 200));
        if (mDownloads.size() > 0)
            mList.setSelectedIndex(0);

        getContentPane().add(BorderLayout.NORTH, descPanel);
        getContentPane().add(BorderLayout.CENTER, centerPanel);

        // Buttons panel
        JPanel			buttonPanel = new JPanel(new FlowLayout());
        JButton			ok = new JButton("OK");
        JButton			cancel = new JButton("Cancel");
        ActionListener	actionListener = new ActionListener()
        {
            public void actionPerformed(ActionEvent event)
            {
                if (!event.getActionCommand().equals("Cancel"))
                {
                    if (!doOk())
                        return;
                }
                else
                {
                    mCancel = true;
                }
                setVisible(false);
            }
        };

        ok.addActionListener(actionListener);
        ok.setMnemonic('O');
        cancel.addActionListener(actionListener);
        cancel.setMnemonic('C');
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        getContentPane().add(BorderLayout.SOUTH, buttonPanel);

        addKeyListener(this);

        pack();

        BaseFrame.centerWindow(this, new Point(0, 0));
    }


    public DownloadFile getDownloadFile()
    {
        return mDownloadFile;
    }


    public boolean getCancel()
    {
        return mCancel;
    }


    private boolean doOk()
    {
        DownloadFile	obj = (DownloadFile)mList.getSelectedValue();

        if (obj == null)
        {
            return false;
        }

        mDownloadFile = obj;
        mCancel = false;
        return true;
    }


    // KeyListener implementation
    public void keyPressed(KeyEvent e)
    {
    }


    public void keyReleased(KeyEvent e)
    {
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
        {
            mCancel = true;
            setVisible(false);
        }
        else if (e.getKeyCode() == KeyEvent.VK_ENTER)
        {
            if (!doOk())
                return;
            mCancel = false;
            setVisible(false);
        }
    }


    public void keyTyped(KeyEvent e)
    {
    }

}

