

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */



package phex.dialogues;





import java.awt.*;

import java.awt.event.*;

import java.util.*;



import javax.swing.event.*;

import javax.swing.*;



import phex.*;

import phex.config.*;

import phex.dialogues.*;





public class DlgConfigDisconnect extends JDialog implements KeyListener

{

	private BaseFrame			mFrame;

	private boolean				mCancel;

	private JCheckBox			mApplyPolicy;

	private JTextField			mSendQueueText;

	private JTextField			mDropPacketText;

	private JTextField			mLatencyText;







	public DlgConfigDisconnect(BaseFrame frame)

	{

		super(frame, true);



		setTitle("Configure Disconnect Policy");

		setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);



		// Center panel for holding the fields

		JPanel		centerPanel = new JPanel(new BorderLayout());

		centerPanel.setBorder(

			BorderFactory.createCompoundBorder(

				BorderFactory.createCompoundBorder(

					BorderFactory.createEmptyBorder(20, 20, 6, 20),

					BorderFactory.createEtchedBorder()),

				BorderFactory.createEmptyBorder(16, 20, 20, 20)));



		// Apply panel

		JPanel		applyPanel = new JPanel(new BorderLayout());

		mApplyPolicy = new JCheckBox("Apply disconnect policies.", ServiceManager.sCfg.mDisconnectApplyPolicy);

		applyPanel.add(BorderLayout.CENTER, mApplyPolicy);

		applyPanel.add(BorderLayout.SOUTH, new JLabel(" "));



		// Label panel

		JPanel		labelPanel = new JPanel(new GridLayout(3, 1, 10, 0));

		labelPanel.add(new JLabel("Send Queue Exceeds: "));

		labelPanel.add(new JLabel("Drop Packet Exceeds (%): "));

		labelPanel.add(new JLabel("Latency Timeout Exceeds (sec):"));



		// Data panel

		JPanel		inputPanel = new JPanel(new GridLayout(3, 1, 10, 6));

		mSendQueueText = new JTextField(Integer.toString(ServiceManager.sCfg.mNetMaxSendQueue), 10);

		mDropPacketText = new JTextField(Integer.toString(ServiceManager.sCfg.mDisconnectDropRatio), 10);

		mLatencyText = new JTextField(Integer.toString(ServiceManager.sCfg.mDisconnectLatency / 1000), 10);



		inputPanel.add(mSendQueueText);

		inputPanel.add(mDropPacketText);

		inputPanel.add(mLatencyText);



		centerPanel.add(BorderLayout.NORTH, applyPanel);

		centerPanel.add(BorderLayout.WEST, labelPanel);

		centerPanel.add(BorderLayout.CENTER, inputPanel);



		getContentPane().add(BorderLayout.CENTER, centerPanel);



		// Buttons panel

        JPanel			buttonPanel = new JPanel(new FlowLayout());

		JButton			ok = new JButton("OK");

        JButton			cancel = new JButton("Cancel");

        ActionListener	actionListener = new ActionListener()

		{ 

            public void actionPerformed(ActionEvent event)

			{ 

                if (!event.getActionCommand().equals("Cancel"))

				{

					if (!doOk())

						return;

				}

				else

				{

					mCancel = true;

				}

				setVisible(false);

            }

		};



        ok.addActionListener(actionListener);

		ok.setMnemonic('O');

        cancel.addActionListener(actionListener);

		cancel.setMnemonic('C');

        buttonPanel.add(ok);

		buttonPanel.add(cancel);

        getContentPane().add(BorderLayout.SOUTH, buttonPanel);



		addKeyListener(this);



		pack();



		MainFrame.centerWindow(this, new Point(0, 0));

	}





	public boolean getCancel()

	{

		return mCancel;

	}





	private boolean doOk()

	{

		int		nSendQueue;

		try

		{

			nSendQueue = Integer.parseInt(mSendQueueText.getText().trim());

			if (nSendQueue < 0)

				throw new Exception();

		}

		catch (Exception e)

		{

			JOptionPane.showMessageDialog(mFrame,

										  "Please enter a non-negative integer.",

										  "Please Enter Again",

										  JOptionPane.ERROR_MESSAGE);

			mSendQueueText.requestFocus();

			return false;

		}

		if (nSendQueue > 1000)

			nSendQueue = 1000;



		int		nDropPacket;

		try

		{

			nDropPacket = Integer.parseInt(mDropPacketText.getText().trim());

			if (nDropPacket < 1 || nDropPacket > 100)

				throw new Exception();

		}

		catch (Exception e)

		{

			JOptionPane.showMessageDialog(mFrame,

										  "Please enter a number between 1 and 100.",

										  "Please Enter Again",

										  JOptionPane.ERROR_MESSAGE);

			mDropPacketText.requestFocus();

			return false;

		}



		int		nLatency;

		try

		{

			nLatency = Integer.parseInt(mLatencyText.getText().trim());

			if (nLatency < 0)

				throw new Exception();

		}

		catch (Exception e)

		{

			JOptionPane.showMessageDialog(mFrame,

										  "Please enter a non-negative integer.",

										  "Please Enter Again",

										  JOptionPane.ERROR_MESSAGE);

			mLatencyText.requestFocus();

			return false;

		}



		ServiceManager.sCfg.mDisconnectApplyPolicy = mApplyPolicy.isSelected();

		ServiceManager.sCfg.mNetMaxSendQueue = nSendQueue;

		ServiceManager.sCfg.mDisconnectDropRatio = nDropPacket;

		ServiceManager.sCfg.mDisconnectLatency = nLatency * 1000;

		ServiceManager.sCfg.save();



		mCancel = false;



		return true;

	}





	// KeyListener implementation

	public void keyPressed(KeyEvent e)

	{

	}





	public void keyReleased(KeyEvent e)

	{

		if (e.getKeyCode() == KeyEvent.VK_ESCAPE)

		{

			mCancel = true;

			setVisible(false);

		}

		else if (e.getKeyCode() == KeyEvent.VK_ENTER)

		{

			if (doOk())

			{

				mCancel = false;

				setVisible(false);

			}

		}

	}





	public void keyTyped(KeyEvent e)

	{

	}





}



