
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.dialogues;


import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.event.*;
import javax.swing.*;

import phex.*;
import phex.config.*;
import phex.host.*;
import phex.utils.IPUtils;


public class DlgConfigInvalid extends JDialog implements KeyListener
{
    private BaseFrame			mFrame;
    private Vector				mInvalidHosts;
    private boolean				mCancel;
    private JTextField			mInvalidText;
    private DefaultListModel	mHostModel;
    private JList				mHostList;



    public DlgConfigInvalid(BaseFrame frame, String invalidHost, Vector hosts)
    {
        super(frame, true);
        mFrame = frame;
        mInvalidHosts = new Vector();

        setTitle("Invalid Hosts");
        setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);

        JPanel		descPanel = new JPanel(new BorderLayout());
        descPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        descPanel.add(BorderLayout.CENTER, new JLabel("Invalid hosts will not go into the host catcher."));

        // Center panel for holding the fields
        JPanel		centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                    BorderFactory.createEmptyBorder(20, 20, 6, 20),
                    BorderFactory.createEtchedBorder()),
                BorderFactory.createEmptyBorder(16, 20, 20, 20)));

        // The upper panel
        JPanel		filterInputPanel = new JPanel(new BorderLayout());
        JPanel		filterInputPanel2 = new JPanel(new BorderLayout());
        mInvalidText = new JTextField(invalidHost, 20);
        JButton		addInvalidButton = new JButton("Add");
        addInvalidButton.addActionListener(new AddActionListener());
        filterInputPanel2.add(BorderLayout.CENTER, mInvalidText);
        filterInputPanel2.add(BorderLayout.EAST, addInvalidButton);
        filterInputPanel.add(BorderLayout.NORTH, new JLabel("Invalid Host:"));
        filterInputPanel.add(BorderLayout.CENTER, filterInputPanel2);
        filterInputPanel.add(BorderLayout.SOUTH, new JLabel("  "));

        // The lower panel
        JPanel		hostPanel = new JPanel(new BorderLayout());
        JPanel		hostButtonPanel = new JPanel(new FlowLayout());
        JButton		removeInvalidButton = new JButton("Remove");
        JButton		defaultsButton = new JButton("Reset To Defaults");
        removeInvalidButton.addActionListener(new RemoveActionListener());
        defaultsButton.addActionListener(new DefaultsActionListener());
        hostButtonPanel.add(removeInvalidButton);
        hostButtonPanel.add(defaultsButton);
        mHostModel = new DefaultListModel();
        mHostList = new JList(mHostModel);
        hostPanel.add(BorderLayout.NORTH, new JLabel("Invalid Hosts:"));
        hostPanel.add(BorderLayout.CENTER, new JScrollPane(mHostList));
        hostPanel.add(BorderLayout.SOUTH, hostButtonPanel);

        centerPanel.add(BorderLayout.NORTH, filterInputPanel);
        centerPanel.add(BorderLayout.CENTER, hostPanel);
        getContentPane().add(BorderLayout.NORTH, descPanel);
        getContentPane().add(BorderLayout.CENTER, centerPanel);

        // Buttons panel
        JPanel			buttonPanel = new JPanel(new FlowLayout());
        JButton			ok = new JButton("OK");
        JButton			cancel = new JButton("Cancel");
        ActionListener	actionListener = new ActionListener()
        {
            public void actionPerformed(ActionEvent event)
            {
                if (!event.getActionCommand().equals("Cancel"))
                {
                    if (!doOk())
                        return;
                }
                else
                {
                    mCancel = true;
                }
                setVisible(false);
            }
        };

        ok.addActionListener(actionListener);
        ok.setMnemonic('O');
        cancel.addActionListener(actionListener);
        cancel.setMnemonic('C');
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        getContentPane().add(BorderLayout.SOUTH, buttonPanel);

        addKeyListener(this);

        for (int i = 0; i < hosts.size(); i++)
        {
            String[]	parts = (String[])hosts.elementAt(i);
            String		ip = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
            mHostModel.addElement(ip);
        }

        pack();

        BaseFrame.centerWindow(this, new Point(0, 0));
    }


    public Vector getInvalidHosts()
    {
        return mInvalidHosts;
    }


    public boolean getCancel()
    {
        return mCancel;
    }


    private boolean doOk()
    {
        for (int i = 0; i < mHostModel.size(); i++)
        {
            mInvalidHosts.addElement(IPUtils.splitIP2Parts((String)mHostModel.elementAt(i)));
        }

        mCancel = false;
        return true;
    }


    private class AddActionListener implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
            String				hostAddr = mInvalidText.getText().trim();
            try
            {
                StringTokenizer	tokens = new StringTokenizer(hostAddr, ".");
                String[]		parts = new String[4];

                parts[0] = tokens.nextToken();
                if (!(parts[0].equals("*") || (Integer.parseInt(parts[0]) >= 0 && Integer.parseInt(parts[0]) < 256)))
                {
                    throw new Exception ();
                }
                parts[1] = tokens.nextToken();
                if (!(parts[1].equals("*") || (Integer.parseInt(parts[1]) >= 0 && Integer.parseInt(parts[1]) < 256)))
                {
                    throw new Exception ();
                }
                parts[2] = tokens.nextToken();
                if (!(parts[2].equals("*") || (Integer.parseInt(parts[2]) >= 0 && Integer.parseInt(parts[2]) < 256)))
                {
                    throw new Exception ();
                }
                parts[3] = tokens.nextToken();
                if (!(parts[3].equals("*") || (Integer.parseInt(parts[3]) >= 0 && Integer.parseInt(parts[3]) < 256)))
                {
                    throw new Exception ();
                }
                if (tokens.hasMoreTokens())
                {
                    throw new Exception ();
                }

                for (int i = 0; i < mHostModel.size(); i++)
                {
                    if (hostAddr.equals(mHostModel.elementAt(i)))
                    {
                        JOptionPane.showMessageDialog(mFrame, "'" + hostAddr + "' is already in the list.", "Duplicate Address", JOptionPane.ERROR_MESSAGE);
                        mInvalidText.requestFocus();
                        return;
                    }
                }

                mHostModel.addElement(hostAddr);
            }
            catch (Exception e)
            {
                JOptionPane.showMessageDialog(mFrame, "'" + hostAddr + "' is not a valid IP address.", "Invalid Host Address", JOptionPane.ERROR_MESSAGE);
                mInvalidText.requestFocus();
            }
        }
    }


    private class RemoveActionListener implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
            int[]	indices = mHostList.getSelectedIndices();

            if (indices == null || indices.length == 0)
                return;

            for (int i = indices.length - 1; i >= 0; i--)
            {
                mHostModel.removeElementAt(indices[i]);
            }
            mHostList.clearSelection();
        }
    }


    private class DefaultsActionListener implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
            HostManager		hm = ServiceManager.getHostManager();
            Vector			defaults = Cfg.getDefaultInvalidHosts();

            mHostModel.removeAllElements();
            for (int i = 0; i < defaults.size(); i++)
            {
                String[]	parts = (String[])defaults.elementAt(i);
                String		ip = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
                mHostModel.addElement(ip);
            }
        }
    }


    // KeyListener implementation
    public void keyPressed(KeyEvent e)
    {
    }


    public void keyReleased(KeyEvent e)
    {
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
        {
            mCancel = true;
            setVisible(false);
        }
        else if (e.getKeyCode() == KeyEvent.VK_ENTER)
        {
        }
    }


    public void keyTyped(KeyEvent e)
    {
    }

}

