
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.dialogues;


import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import phex.*;
import phex.gui.common.TextFieldFix;


/**
 *	The DlgInput1Str class is a generic modal dialog box for accepting one 
 *	input from the user.  The usage is to first create a DlgInut1Str object,
 *	passing in all the parameters to the constructor.  Next, call 
 *	setVisible(true) to display the dialog box.  When the user hits OK or
 *	Cancel, the dialog box will be closed.  Call getCanceled() to check
 *	whether the user canceled the dialog box.  Call getValue1() to get
 *	the user input.  Call dispose() to free the dialg box resource.
 */
public class DlgInput1Str extends JDialog implements KeyListener
{
	private TextFieldFix		mTextValue1;
	private String				mValue1;
	private boolean				mCanceled = true;	// default to true.


	/**
	 *	Constructor to build a dialog box.
	 *
	 *	@param frame	the owner frame.
	 *	@param title	the title of the dialog box
	 *	@param label1	the label of the input field
	 *	@param value1	the default value (old value) of the input field.
	 */
	public DlgInput1Str(BaseFrame frame, String title, String desc, String label1, String value1)
	{
		// Call base class to set up modal dialog box.
		super(frame, true);
		mValue1 = value1;
		setTitle(title);

		setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);

		// Set up panel and borders.
		JPanel		outPanel = new JPanel(new BorderLayout());
		outPanel.setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createCompoundBorder(
					BorderFactory.createEmptyBorder(20, 20, 20, 20),
					BorderFactory.createEtchedBorder()),
				BorderFactory.createEmptyBorder(16, 20, 20, 20)));

		JPanel		descPanel = new JPanel(new BorderLayout());
		descPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
		descPanel.add(BorderLayout.CENTER, new JLabel(desc));

		JPanel		topPanel = new JPanel();
		topPanel.setLayout(new GridLayout(2, 1, 0, 0));

		// Add label and input field.
		topPanel.add(new JLabel(label1));
		mTextValue1 = new TextFieldFix(mValue1, 20);
		topPanel.add(mTextValue1);

		outPanel.add(BorderLayout.NORTH, descPanel);
		outPanel.add(BorderLayout.CENTER, topPanel);

		getContentPane().add(BorderLayout.CENTER, outPanel);

		// Listener for the OK and Cancel buttons.
		ActionListener	actionListener = new ActionListener()
		{ 
			public void actionPerformed(ActionEvent event)
			{ 
				if (!event.getActionCommand().equals("Cancel"))
				{
					mValue1 = mTextValue1.getText();
					mCanceled = false;
				}
				setVisible(false);
			}
		};

		// Set up the OK and Cancel buttons.
		JPanel		buttonPanel = new JPanel();
		JButton		ok = new JButton("OK");
		JButton		cancel = new JButton("Cancel");
		ok.setMnemonic('O');
		ok.addActionListener(actionListener);
		cancel.addActionListener(actionListener);
		cancel.setMnemonic('C');
		buttonPanel.add(ok);
		buttonPanel.add(cancel);
		getContentPane().add(BorderLayout.SOUTH, buttonPanel);

		addKeyListener(this);

		pack();

		BaseFrame.centerWindow(this, new Point(0, 0));
	}


	/**
	 *	Returns the cancel flag.
	 *
	 *	@return		true = user canceled, false = user hits OK.
	 */
	public boolean getCanceled()
	{
		return mCanceled;
	}


	/**
	 *	Returns the input value.
	 *
	 *	@return		the input value.
	 */
	public String getValue1()
	{
		return mValue1;
	}



	// KeyListener implementation
	public void keyPressed(KeyEvent e)
	{
	}


	public void keyReleased(KeyEvent e)
	{
		if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
		{
			mCanceled = true;
			setVisible(false);
		}
		else if (e.getKeyCode() == KeyEvent.VK_ENTER)
		{
			mValue1 = mTextValue1.getText();
			mCanceled = false;
			setVisible(false);
		}
	}


	public void keyTyped(KeyEvent e)
	{
	}

}


