
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.dialogues;


import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import phex.*;


public class DlgLog extends JDialog implements KeyListener
{
    public DlgLog(BaseFrame frame, String title, String label1, String text)
    {
        // Call base class to set up modal dialog box.
        super(frame, true);
        setTitle(title);

        setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);

        // Set up panel and borders.
        JPanel outPanel = new JPanel(new BorderLayout());
        outPanel.setBorder(
            BorderFactory.createCompoundBorder(
                BorderFactory.createCompoundBorder(
                    BorderFactory.createEmptyBorder(20, 20, 20, 20),
                    BorderFactory.createEtchedBorder()),
                BorderFactory.createEmptyBorder(16, 20, 20, 20)));

        // Add label and input field.
        outPanel.add(BorderLayout.NORTH, new JLabel(label1));
        outPanel.add(BorderLayout.CENTER,
            new JScrollPane( new JTextArea( text, 15, 50 ) ) );

        getContentPane().add(BorderLayout.CENTER, outPanel);

        // Listener for the OK and Cancel buttons.
        ActionListener	actionListener = new ActionListener()
        {
            public void actionPerformed(ActionEvent event)
            {
                setVisible(false);
            }
        };

        // Set up the OK and Cancel buttons.
        JPanel		buttonPanel = new JPanel();
        JButton		ok = new JButton("OK");
        ok.setMnemonic('O');
        ok.addActionListener(actionListener);
        buttonPanel.add(ok);
        getContentPane().add(BorderLayout.SOUTH, buttonPanel);

        addKeyListener(this);

        pack();

        BaseFrame.centerWindow(this, new Point(0, 0));
    }


    // KeyListener implementation
    public void keyPressed(KeyEvent e)
    {
    }


    public void keyReleased(KeyEvent e)
    {
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
        {
            setVisible(false);
        }
        else if (e.getKeyCode() == KeyEvent.VK_ENTER)
        {
            setVisible(false);
        }
    }


    public void keyTyped(KeyEvent e)
    {
    }

}


