/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.common;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import phex.ServiceManager;
import phex.utils.Localizer;

public final class GUIUtils
{
    private GUIUtils()
    {
    }

    public static void adjustTableProgresssBarHeight( JTable table )
    {
        Font progressFont = (Font) UIManager.getDefaults().get( "ProgressBar.font" );
        FontMetrics fontMetrics = table.getFontMetrics( progressFont );
        // no descent used since numbers have no descent...
        int height = fontMetrics.getHeight() + fontMetrics.getDescent();
        table.setRowHeight( height );
    }

    /**
     * Sets a tool tip text to a component if it's enabled in the configuration.
     */
    public static void setToolTipText(JComponent comp, String tooltip)
    {
        if ( ServiceManager.sCfg.mUIDisplayTooltip )
        {
            comp.setToolTipText( tooltip );
        }
    }

    /**
     * Fires a table changed event.
     * @todo verify jdk1.3 bug...
     */
    public static void fireTableChanged(JTable table, AbstractTableModel model)
    {
        // Go through freaking hoops to work around the table selection bug in JDK 1.3.
        // Save the table selection before firing the table changed event.
        int		rowCount = table.getSelectedRowCount();
        int[]	rows = table.getSelectedRows();

        // Fire the event
        model.fireTableDataChanged();

        // Restore the table selection.
        if (rowCount > 0)
        {
            for (int i = 0; i < rows.length; i++)
            {
                if (rows[i] < table.getRowCount())
                    table.addRowSelectionInterval(rows[i], rows[i]);
            }
        }
    }

    public static void showErrorMessage( String message )
    {
        showErrorMessage( ServiceManager.getManager().getMainFrame(), message );
    }

    public static void showErrorMessage( String message, String title )
    {
        showErrorMessage( null, message, title );
    }

    public static void showErrorMessage( Component parent, String message )
    {
        showErrorMessage( parent, message, Localizer.getString( "Error" ) );
    }

    public static void showErrorMessage( Component parent, String message,
        String title )
    {
        if ( parent == null )
        {
            parent = ServiceManager.getManager().getMainFrame();
        }
        JOptionPane.showMessageDialog( parent, message,
            title, JOptionPane.ERROR_MESSAGE );
    }
}