/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.common;

import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

/**
 * This Panel provides the ability to show a multiline label
 */
public class MultiLinePanel extends JPanel
{
   private int lineCount;

   private GridBagLayout layout = new GridBagLayout();
   private GridBagConstraints constrain = new GridBagConstraints();

   public MultiLinePanel(String text)
   {
      super();
      lineCount = 0;
      setLayout( layout );
      burstStringIntoPanel( text );
   }

   public void setText( String str )
   {
      removeAll();
      lineCount = 0;
      burstStringIntoPanel( str );
      revalidate();
   }

   private void burstStringIntoPanel( String str )
   {
      int index = str.indexOf('\n');
      if (index >= 0)
      {
         if ( index == 0 )
         {
            // I put a space here since other wise a empty line is not very high
            addLabel(" ");
            burstStringIntoPanel( str.substring( index + 1 ) );
         }
         else
         {
            addLabel( str.substring( 0, index ) );
            burstStringIntoPanel( str.substring( index + 1 ) );
         }
      }
      else
      {
         addLabel(str);
      }
   }

   private void addLabel(String str)
   {
      JLabel label = new JLabel( str );
      constrain.gridx = 0;
      constrain.gridy = lineCount;
      constrain.gridwidth = 1;
      constrain.gridheight = 1;
      constrain.fill = GridBagConstraints.NONE;
      constrain.ipadx = 0;
      constrain.ipady = 0;

      if ( lineCount == 0 )
      {
         constrain.insets = new Insets( 2, 2, 0, 2 );
      }
      else
      {
         constrain.insets = new Insets( 0, 2, 0, 2 );
      }

      constrain.anchor = GridBagConstraints.WEST;
      constrain.weightx = 1;
      constrain.weighty = 0;
      layout.setConstraints(label,constrain);
      add(label);

      lineCount ++;
   }
}