
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package phex.gui.common;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;


/**
 * Jumping through hoop to get around this stupid alt-key in textfield bug in JDK 1.2.
 * Refer to bug  4246708, 4243366, 4257283
 * <p>
 * This meant that while alt is pressed keys are send to the menu and to the textfield.
 * There where other issues with the alt key but please refer to TextFieldFix for details.
 * <p>
 * Both problems seams to be fixed in java 1.4 because of a new focus manager.
 */
public class TextFieldFactory
{
    /**
     * @deprecated I see no reason to have this anymore since all the mentioned
     * bugs are not reproducable with J2SEE 1.3. This method just returns a simple
     * JTextField.
     */
    public static JTextField newTextField(String str, int columns)
    {
        JTextField	text = null;

        //if (isVersion11() || isVersion13())
        {
            text = new JTextField();
        }
/*        else
        {
            try
            {
                text = (JTextField)Class.forName("phex.gui.common.TextFieldFix").newInstance();
            }
            catch (Exception e)
            {
                System.out.println(e);
            }
        }
        */

        text.setText( str );
        text.setColumns( columns );

        return text;
    }


    private static boolean isVersion11()
    {
        String	vers = System.getProperty("java.version");
        if (vers.compareTo("1.2") < 0)
        {
            return true;
        }
        return false;
    }


    private static boolean isVersion13()
    {
        String	vers = System.getProperty("java.version");
        if (vers.compareTo("1.4") < 0)
        {
            return true;
        }
        return false;
    }

}

