/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.dialogs.options;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import phex.ServiceManager;
import phex.gui.common.IntegerTextField;
import phex.gui.common.GUIUtils;
import phex.utils.Localizer;

public class NetworkPane extends OptionsSettingsPane
{
    private static final String LISTENING_PORT_KEY = "ListeningPort";
    private static final String MY_TTL_KEY = "MyTTL";
    private static final String MAX_TTL_KEY = "MaxTTL";
    private static final String MIN_CONNECTIONS_KEY = "MinConnections";
    private static final String MAX_CONNECTIONS_KEY = "MaxConnections";
    private static final String CONNECTION_TIMEOUT_KEY = "ConnectionTimeout";
    private static final String PING_FREQUENCY_KEY = "PingFrequency";
    private static final String PING_TIMEOUT_KEY = "PingTimeout";
    private static final String PROXY_PORT_KEY = "ProxyPort";

    private IntegerTextField listeningPortTF;
    private IntegerTextField myTTLTF;
    private IntegerTextField maxTTLTF;
    private IntegerTextField minConnectionsTF;
    private IntegerTextField maxConnectionsTF;
    private IntegerTextField connectionTimeoutTF;
    private IntegerTextField pingFrequencyTF;
    private IntegerTextField pingTimeoutTF;
    private JCheckBox behindFirewallCkbx;
    private JLabel exportIPLabel;
    private JTextField exportIPTF;
    private JCheckBox socks5ProxyCkbx;
    private JLabel hostLabel;
    private JTextField proxyHostTF;
    private JLabel portLabel;
    private IntegerTextField proxyPortTF;
    private JCheckBox authenticationCkbx;
    private JLabel userLabel;
    private JTextField userNameTF;
    private JLabel passwordLabel;
    private JPasswordField passwordTF;


    public NetworkPane()
    {
        super( "Network" );
    }

    /**
     * Called when preparing this settings pane for display the first time. Can
     * be overriden to implement the look of the settings pane.
     */
    protected void prepareComponent()
    {
        GridBagConstraints constraints;
        setLayout( new GridBagLayout() );

        JPanel networkPanel = new JPanel( new GridBagLayout() );
        networkPanel.setBorder( BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(),
            Localizer.getString( "NetworkSettings" ) ) );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.BOTH;
            constraints.weightx = 1;
        add( networkPanel, constraints );

        JPanel panel = new JPanel( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 3, 0, 5, 0 );
            constraints.weightx = 1;
        networkPanel.add( panel, constraints );

        JLabel label = new JLabel( Localizer.getString( "ListeningPort" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 5 );
        panel.add( label, constraints );

        listeningPortTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mListeningPort ), 5, 5 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( listeningPortTF, constraints );

        label = new JLabel( Localizer.getString( "MyTTL" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 5 );
        panel.add( label, constraints );

        myTTLTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mNetTTL ), 2, 2 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( myTTLTF, constraints );

        label = new JLabel( Localizer.getString( "MaxTTL" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 20, 3, 5 );
        panel.add( label, constraints );

        maxTTLTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mNetMaxTTL ), 2, 2 );
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( maxTTLTF, constraints );

        label = new JLabel( Localizer.getString( "MinConnections" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 5 );
        panel.add( label, constraints );

        minConnectionsTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mNetMinConn ), 2, 2 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( minConnectionsTF, constraints );

        label = new JLabel( Localizer.getString( "MaxConnections" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 20, 3, 5 );
        panel.add( label, constraints );

        maxConnectionsTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mNetMaxConnection ), 2, 2 );
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( maxConnectionsTF, constraints );


/*        panel = new JPanel( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 3, 0, 5, 0 );
        networkPanel.add( panel, constraints );*/

        label = new JLabel( Localizer.getString( "PingFrequency" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 5 );
        panel.add( label, constraints );

        pingFrequencyTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mPingFrequency / 1000 ), 2, 2 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 3;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( pingFrequencyTF, constraints );

        label = new JLabel( Localizer.getString( "PingTimeout" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 20, 3, 5 );
        panel.add( label, constraints );

        pingTimeoutTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mPingTimeout / 1000 ), 2, 2 );
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = 3;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( pingTimeoutTF, constraints );

        label = new JLabel( Localizer.getString( "ConnectionTimeout" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.anchor = GridBagConstraints.NORTHEAST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 5 );
        panel.add( label, constraints );

        connectionTimeoutTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mNetConnectionTimeout / 1000 ), 3, 3 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 4;
            constraints.gridwidth = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 3, 0 );
        panel.add( connectionTimeoutTF, constraints );

        JPanel firewallPanel = new JPanel( new GridBagLayout() );
        firewallPanel.setBorder( BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(),
            Localizer.getString( "FirewallProxySettings" ) ) );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.BOTH;
            constraints.weightx = 1;
            constraints.weighty = 1;
        add( firewallPanel, constraints );

        panel = new JPanel( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 6, 0 );
            constraints.weightx = 1;
        firewallPanel.add( panel, constraints );

        exportIPLabel = new JLabel( Localizer.getString( "ExportIPAs" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 0, 5 );
        panel.add( exportIPLabel, constraints );

        exportIPTF = new JTextField(
            ServiceManager.sCfg.mMyIP, 15 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.weightx = 1;
        panel.add( exportIPTF, constraints );

        behindFirewallCkbx = new JCheckBox(
            Localizer.getString( "BehindFirewall" ), ServiceManager.sCfg.isBehindFirewall );
        behindFirewallCkbx.addActionListener( new CheckboxActionListener() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 2, 0, 0, 0 );
            constraints.weightx = 1;
        firewallPanel.add( behindFirewallCkbx, constraints );

        panel = new JPanel( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 2, 0 );
            constraints.weightx = 1;
        firewallPanel.add( panel, constraints );

        socks5ProxyCkbx = new JCheckBox(
            Localizer.getString( "UseSocks5Proxy" ), ServiceManager.sCfg.mProxyUse );
        socks5ProxyCkbx.addActionListener( new CheckboxActionListener() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 2, 0 );
        panel.add( socks5ProxyCkbx, constraints );

        hostLabel = new JLabel( Localizer.getString( "ProxyHostIP" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 15, 2, 5 );
        panel.add( hostLabel, constraints );

        proxyHostTF = new JTextField(
            ServiceManager.sCfg.mProxyHost, 15 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            //constraints.weightx = 1;
        panel.add( proxyHostTF, constraints );

        portLabel = new JLabel( Localizer.getString( "Port" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 5, 2, 5 );
        panel.add( portLabel, constraints );

        proxyPortTF = new IntegerTextField(
            String.valueOf( ServiceManager.sCfg.mProxyPort ), 5, 5 );
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.weightx = 1;
        panel.add( proxyPortTF, constraints );

        authenticationCkbx = new JCheckBox(
            Localizer.getString( "Authentication" ),
            ServiceManager.sCfg.useProxyAuthentication );
        authenticationCkbx.addActionListener( new CheckboxActionListener() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 15, 2, 0 );
        firewallPanel.add( authenticationCkbx, constraints );

        panel = new JPanel( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.BOTH;
            constraints.insets = new Insets( 0, 15, 2, 0 );
            constraints.weightx = 1;
            constraints.weighty = 1;
        firewallPanel.add( panel, constraints );

        userLabel = new JLabel( Localizer.getString( "Username" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 0, 0, 5 );
        panel.add( userLabel, constraints );

        userNameTF = new JTextField(
            ServiceManager.sCfg.mProxyUserName, 10 );
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
        panel.add( userNameTF, constraints );

        passwordLabel = new JLabel( Localizer.getString( "Password" ) + ": " );
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.insets = new Insets( 0, 5, 0, 5 );
        panel.add( passwordLabel, constraints );

        passwordTF = new JPasswordField(
            ServiceManager.sCfg.mProxyPassword, 10 );
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = 1;
            constraints.anchor = GridBagConstraints.NORTHWEST;
            constraints.fill = GridBagConstraints.NONE;
            constraints.weightx = 1;
            constraints.weighty = 1;
        panel.add( passwordTF, constraints );

        refreshEnableState();
    }

    /**
     * Override this method if you like to verify inputs before storing them.
     * A input dictionary is given to the pane. It can be used to store values
     * like error flags or prepared values for saving. The dictionary is given
     * to every settings pane checkInput(), displayErrorMessage() and
     * saveAndApplyChanges() method.
     * When the input has been flaged as invalid with the method setInputValid()
     * the method displayErrorMessage() is called directly after return of
     * checkInput() and the focus is given to settings pane.
     * After checking all settings pane without any error the method
     * saveAndApplyChanges() is called for all settings panes to save the
     * changes.
     */
    public void checkInput( HashMap inputDic )
    {
        try
        {
            String listeningPortStr = listeningPortTF.getText();
            Integer listeningPort = new Integer( listeningPortStr );
            inputDic.put( LISTENING_PORT_KEY, listeningPort );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, listeningPortTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String myTTLStr = myTTLTF.getText();
            Integer myTTL = new Integer( myTTLStr );
            inputDic.put( MY_TTL_KEY, myTTL );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, myTTLTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String maxTTLStr = maxTTLTF.getText();
            Integer maxTTL = new Integer( maxTTLStr );
            inputDic.put( MAX_TTL_KEY, maxTTL );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, maxTTLTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String minConnStr = minConnectionsTF.getText();
            Integer minConn = new Integer( minConnStr );
            inputDic.put( MIN_CONNECTIONS_KEY, minConn );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, minConnectionsTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String maxConnStr = maxConnectionsTF.getText();
            Integer maxConn = new Integer( maxConnStr );
            inputDic.put( MAX_CONNECTIONS_KEY, maxConn );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, maxConnectionsTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String connTimeoutStr = connectionTimeoutTF.getText();
            Integer connTimeout = new Integer( connTimeoutStr );
            inputDic.put( CONNECTION_TIMEOUT_KEY, connTimeout );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, connectionTimeoutTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String pingFrequencyStr = pingFrequencyTF.getText();
            Integer pingFrequency = new Integer( pingFrequencyStr );
            inputDic.put( PING_FREQUENCY_KEY, pingFrequency );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, pingFrequencyTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String pingTimeoutStr = pingTimeoutTF.getText();
            Integer pingTimeout = new Integer( pingTimeoutStr );
            inputDic.put( PING_TIMEOUT_KEY, pingTimeout );
        }
        catch ( NumberFormatException exp )
        {
            inputDic.put( NUMBER_FORMAT_ERROR_KEY, pingTimeoutTF );
            setInputValid( inputDic, false );
            return;
        }

        try
        {
            String proxyPortStr = proxyPortTF.getText();
            Integer proxyPort = new Integer( proxyPortStr );
            inputDic.put( PROXY_PORT_KEY, proxyPort );
        }
        catch ( NumberFormatException exp )
        {// we don't care because we will use default value on saving...
        }

        setInputValid( inputDic, true );
    }

    /**
     * When isInputValid() returns a false this method is called.
     * The input dictionary should contain the settings pane specific information
     * of the error.
     * The settings pane should override this method to display a error
     * message. Before calling the method the focus is given to the
     * settings pane.
     */
    public void displayErrorMessage( HashMap inputDic )
    {
        if ( inputDic.containsKey( NUMBER_FORMAT_ERROR_KEY ) )
        {
            displayNumberFormatError( inputDic );
        }
    }

    /**
     * Override this method if you like to apply and save changes made on
     * settings pane. To trigger saving of the configuration if any value was
     * changed call triggerConfigSave().
     */
    public void saveAndApplyChanges( HashMap inputDic )
    {
        String myIP = exportIPTF.getText();
        if ( !ServiceManager.sCfg.mMyIP.equals( myIP ) )
        {
            ServiceManager.sCfg.mMyIP = myIP;
            OptionsSettingsPane.triggerConfigSave( inputDic );
            ServiceManager.getListener().setMyIP( ServiceManager.sCfg.mMyIP );
        }

        Integer listeningPortInt = (Integer) inputDic.get(
            LISTENING_PORT_KEY );
        int listeningPort = listeningPortInt.intValue();
        if ( ServiceManager.sCfg.mListeningPort != listeningPort )
        {
            ServiceManager.sCfg.mListeningPort = listeningPort;
            OptionsSettingsPane.triggerConfigSave( inputDic );

            ServiceManager.getListener().shutdown(true);
            try
            {
                ServiceManager.getListener().startup();
            }
            catch (Exception e)
            {
                GUIUtils.showErrorMessage(
                    Localizer.getString( "FailedToListenOnNewPort" ),
                    Localizer.getString( "ListenerError" ) );
            }
        }

        Integer myTTLInt = (Integer) inputDic.get( MY_TTL_KEY );
        int myTTL = myTTLInt.intValue();
        if ( ServiceManager.sCfg.mNetTTL != myTTL )
        {
            ServiceManager.sCfg.mNetTTL = myTTL;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer maxTTLInt = (Integer) inputDic.get( MAX_TTL_KEY );
        int maxTTL = maxTTLInt.intValue();
        if ( ServiceManager.sCfg.mNetMaxTTL != maxTTL )
        {
            ServiceManager.sCfg.mNetMaxTTL = maxTTL;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer minConnectionsInt = (Integer) inputDic.get( MIN_CONNECTIONS_KEY );
        int minConnections = minConnectionsInt.intValue();
        if ( ServiceManager.sCfg.mNetMinConn != minConnections )
        {
            ServiceManager.sCfg.mNetMinConn = minConnections;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer maxConnectionsInt = (Integer) inputDic.get( MAX_CONNECTIONS_KEY );
        int maxConnections = maxConnectionsInt.intValue();
        if ( ServiceManager.sCfg.mNetMaxConnection != maxConnections )
        {
            ServiceManager.sCfg.mNetMaxConnection = maxConnections;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer connectionTimeoutInt = (Integer) inputDic.get( CONNECTION_TIMEOUT_KEY );
        int connectionTimeout = connectionTimeoutInt.intValue() * 1000;
        if ( ServiceManager.sCfg.mNetConnectionTimeout != connectionTimeout )
        {
            ServiceManager.sCfg.mNetConnectionTimeout = connectionTimeout;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer pingFrequencyInt = (Integer) inputDic.get( PING_FREQUENCY_KEY );
        int pingFrequency = pingFrequencyInt.intValue() * 1000;
        if ( ServiceManager.sCfg.mPingFrequency != pingFrequency )
        {
            ServiceManager.sCfg.mPingFrequency = pingFrequency;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer pingTimeoutInt = (Integer) inputDic.get( PING_TIMEOUT_KEY );
        int pingTimeout = pingTimeoutInt.intValue() * 1000;
        if ( ServiceManager.sCfg.mPingTimeout != pingTimeout )
        {
            ServiceManager.sCfg.mPingTimeout = pingTimeout;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        boolean behindFirewall = behindFirewallCkbx.isSelected();
        if ( ServiceManager.sCfg.isBehindFirewall != behindFirewall )
        {
            ServiceManager.sCfg.isBehindFirewall = behindFirewall;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        boolean useSocks5Proxy = socks5ProxyCkbx.isSelected();
        if ( ServiceManager.sCfg.mProxyUse != useSocks5Proxy )
        {
            ServiceManager.sCfg.mProxyUse = useSocks5Proxy;
            OptionsSettingsPane.triggerConfigSave( inputDic );
            ServiceManager.getManager().getMainFrame().setTitle();
        }

        String proxyHost = proxyHostTF.getText();
        if ( !ServiceManager.sCfg.mProxyHost.equals( proxyHost ) )
        {
            ServiceManager.sCfg.mProxyHost = proxyHost;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        Integer proxyPortInt = (Integer) inputDic.get( PROXY_PORT_KEY );
        int proxyPort = ServiceManager.sCfg.DEFAULT_SOCKS5_PORT;
        if ( proxyPortInt != null )
        {
            proxyPort = proxyPortInt.intValue();
        }
        if ( ServiceManager.sCfg.mProxyPort != proxyPort )
        {
            ServiceManager.sCfg.mProxyPort = proxyPort;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        boolean useAuthentication = authenticationCkbx.isSelected();
        if ( ServiceManager.sCfg.useProxyAuthentication != useAuthentication )
        {
            ServiceManager.sCfg.useProxyAuthentication = useAuthentication;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        String userName = userNameTF.getText();
        if ( !ServiceManager.sCfg.mProxyUserName.equals( userName ) )
        {
            ServiceManager.sCfg.mProxyUserName = userName;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }

        String password = new String( passwordTF.getPassword() );
        if ( !ServiceManager.sCfg.mProxyPassword.equals( password ) )
        {
            ServiceManager.sCfg.mProxyPassword = password;
            OptionsSettingsPane.triggerConfigSave( inputDic );
        }
    }

    private void refreshEnableState()
    {
        //exportIPLabel.setEnabled( behindFirewallCkbx.isSelected() );
        //exportIPTF.setEnabled( behindFirewallCkbx.isSelected() );
        socks5ProxyCkbx.setEnabled( behindFirewallCkbx.isSelected() );
        hostLabel.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() );
        proxyHostTF.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() );
        portLabel.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() );
        proxyPortTF.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() );

        authenticationCkbx.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() );
        userLabel.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() &&
            authenticationCkbx.isSelected() );
        userNameTF.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() &&
            authenticationCkbx.isSelected() );
        passwordLabel.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() &&
            authenticationCkbx.isSelected() );
        passwordTF.setEnabled( behindFirewallCkbx.isSelected() &&
            socks5ProxyCkbx.isSelected() &&
            authenticationCkbx.isSelected() );
    }

    class CheckboxActionListener implements ActionListener
    {
        public void actionPerformed( ActionEvent e )
        {
            refreshEnableState();
        }
    }
}