package phex.msg;

import java.net.URLDecoder;

public class GETRequest
{
    private int index;
    private String filename;
    private String operation;

    public GETRequest( String getLine )
    {
        // find end of get
        int getEndIdx = getLine.indexOf( "/get/" ) + 5;

        operation = getLine.substring( getEndIdx - 4, getEndIdx - 1 );

        // find end of index
        int indexEndIdx = getLine.indexOf( "/", getEndIdx );

        String indexStr = getLine.substring( getEndIdx, indexEndIdx );
        try
        {
            index = Integer.parseInt( indexStr );
        }
        catch ( NumberFormatException exp )
        {
            // we need to try check for file name instead for index
            index = -1;
        }

        // the file name end with the HTTP/ statement string
        int fileEndIdx = getLine.indexOf( " HTTP/", indexEndIdx );
        filename = URLDecoder.decode(
            getLine.substring( indexEndIdx + 1, fileEndIdx ) );
    }

    public String getOperation()
    {
        return operation;
    }

    public String getFileName()
    {
        return filename;
    }

    public int getFileIndex()
    {
        return index;
    }
}