

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex.msg;



import phex.*;

import phex.config.*;

import phex.host.*;

import phex.utils.*;





public class MsgHeader

{

	// Constant

	public static final int		sDataLength = GUID.sDataLength + 7;



	// Function type constants

	public static final int		sInit = 0x0;

	public static final int		sInitResponse = 0x1;

	public static final int		sPushRequest = 0x40;

	public static final int		sQuery = 0x80;

	public static final int		sQueryResponse = 0x81;

	public static final int		sCChat = 0x8E;

	public static final int		sUnknown = 0xFF;





	// Atributes

	private GUID			mMsgID;

	private int				mFunction;			// message type

	private int				mTTL;

	private int				mHopsTaken;

	private int				mDataLen;



	private long			mArrivalTime;

	private Host			mFromHost = null;





	public MsgHeader()

	{

		mMsgID = new GUID();

		mFunction = sUnknown;

		mTTL = ServiceManager.sCfg.mNetTTL;

		mHopsTaken = 0;

		mDataLen = 0;

	}





	public MsgHeader(GUID guid)

	{

		mMsgID = guid;

		mFunction = sUnknown;

		mTTL = 0;

		mHopsTaken = 0;

		mDataLen = 0;

	}





	public GUID getMsgID()

	{

		return mMsgID;

	}





	public void setMsgID(GUID MsgID)

	{

		this.mMsgID = MsgID;

	}



	

	public int getFunction()

	{

		return mFunction;

	}





	public void setFunction(int Function)

	{

		this.mFunction = Function;

	}





	public String getFunctionName()

	{

		switch (mFunction)

		{

			case sInit:

				return "Init";

			case sInitResponse:

				return "InitResponse";

			case sCChat:

				return "Channel Chat";

			case sPushRequest:

				return "PushRequest";

			case sQuery:

				return "Query";

			case sQueryResponse:

				return "QueryResponse";

			default:

				return "Unknown";

		}

	}



	

	public int getTTL()

	{

		return mTTL;

	}





	public void setTTL(int TTL)

	{

		this.mTTL = TTL;

	}



	

	public int getHopsTaken()

	{

		return mHopsTaken;

	}





	public void setHopsTaken(int HopsTaken)

	{

		this.mHopsTaken = HopsTaken;

	}



	

	public int getDataLen()

	{

		return mDataLen;

	}





	public void setDataLen(int DataLen)

	{

		this.mDataLen = DataLen;

	}





	public long getArrivalTime()

	{

		return mArrivalTime;

	}





	public void setArrivalTime(long arrivalTime)

	{

		this.mArrivalTime = arrivalTime;

	}





	public Host getFromHost()

	{

		return mFromHost;

	}





	public void setFromHost(Host fromHost)

	{

		this.mFromHost = fromHost;

	}





	public int getSize()

	{

		return sDataLength;

	}





	public void copy(MsgHeader b)

	{

		mMsgID = b.mMsgID;

		mFunction = b.mFunction;

		mTTL = b.mTTL;

		mHopsTaken = b.mHopsTaken;

		mDataLen = b.mDataLen;

	}







	public int serialize(byte[] outbuf, int offset)

			throws Exception

	{

		offset = mMsgID.serialize(outbuf, offset);

		outbuf[offset++] = (byte)mFunction;

		outbuf[offset++] = (byte)mTTL;

		outbuf[offset++] = (byte)mHopsTaken;

		offset = IOUtil.serializeIntLE(mDataLen, outbuf, offset);	// Convert to Intel little-endian



		return offset;

	}





	public int deserialize(byte[] inbuf, int offset)

			throws Exception

	{

		offset = mMsgID.deserialize(inbuf, offset);

		mFunction = inbuf[offset++];

		mFunction = (mFunction < 0 ? mFunction + 256 : mFunction);

		mTTL = inbuf[offset++];

		mTTL = (mTTL < 0 ? mTTL + 256 : mTTL);

		mHopsTaken = inbuf[offset++];

		mHopsTaken = (mHopsTaken < 0 ? mHopsTaken + 256 : mHopsTaken);

		mDataLen = IOUtil.deserializeIntLE(inbuf, offset);

		offset += 4;



		return offset;

	}





	public String toString()

	{

		return	"[" +

				"MsgID=" + mMsgID + ", " +

				"Function=" + mFunction + "(" + getFunctionName() + "), " +

				"TTL=" + mTTL + ", " +

				"HopsTaken=" + mHopsTaken + ", " +

				"DataLen=" + mDataLen + 

				"]";

	}









}





