
/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2000 William W. Wong
 *  williamw@jps.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package phex.msg;


import java.net.*;

import phex.*;
import phex.interfaces.*;
import phex.utils.*;


public class MsgPushRequest implements IMsg
{
    private MsgHeader	mHeader;
    private GUID		mClientID;
    private int mFileIndex;
    private String requestHost;
    private short requestPort;


    private MsgPushRequest()
    {
    }


    public MsgPushRequest(MsgHeader header)
    {
        setHeader(header);
        mClientID = new GUID();
        mFileIndex = -1;
        requestHost = null;
        requestPort = 0;
    }


    public void setHeader(MsgHeader header)
    {
        mHeader = header;
        mHeader.setFunction(MsgHeader.sPushRequest);
    }


    public MsgHeader getHeader()
    {
        return mHeader;
    }


    public GUID getClientID()
    {
        return mClientID;
    }


    public void setClientID(GUID ClientID)
    {
        this.mClientID = ClientID;
    }


    public int getFileIndex()
    {
        return mFileIndex;
    }


    public void setFileIndex(int mFileIndex)
    {
        this.mFileIndex = mFileIndex;
    }


    public String getRequestHost()
    {
        return requestHost;
    }


    public void setRequestHost( String aRequestHost )
    {
        requestHost = aRequestHost;
    }


    public short getRequestPort()
    {
        return requestPort;
    }


    public void setRequestPort(short aRequestPort)
    {
        requestPort = aRequestPort;
    }




    public void computeHeaderLen()
    {
        mHeader.setDataLen(getSize() - mHeader.getSize());
    }


    public int getSize()
    {
        return	mHeader.getSize() +
                mClientID.getSize() +
                4 + 4 + 2;
    }


    public void copy(MsgPushRequest b)
    {
        mHeader.copy(b.getHeader());

        mClientID = b.mClientID;
        mFileIndex = b.mFileIndex;
        requestHost = b.requestHost;
        requestPort = b.requestPort;
    }


    public int serialize(byte[] outbuf, int offset)
            throws Exception
    {
        offset = mHeader.serialize(outbuf, offset);
        offset = mClientID.serialize(outbuf, offset);
        // Convert to Intel little-endian
        offset = IOUtil.serializeIntLE(mFileIndex, outbuf, offset);
        InetAddress addi = InetAddress.getByName( requestHost );
        System.arraycopy( addi.getAddress(), 0, outbuf, offset, 4 );
        offset += 4;
        offset = IOUtil.serializeShortLE( requestPort, outbuf, offset );

        return offset;
    }


    public int deserialize(byte[] inbuf, int offset)
            throws Exception
    {
        // Already read the header.
        offset = mClientID.deserialize(inbuf, offset);
        mFileIndex = IOUtil.deserializeIntLE(inbuf, offset);
        offset += 4;
        StringBuffer strBuf = new StringBuffer();
        offset = IOUtil.deserializeIP(inbuf, offset, strBuf);
        requestHost = strBuf.toString();
        requestPort = IOUtil.deserializeShortLE(inbuf, offset);
        offset += 2;

        return offset;
    }


    public String toString()
    {
        return	"[" +
                mHeader + " " +
                "ClientID=" + mClientID + ", " +
                "FileIndex=" + mFileIndex + ", " +
                "RequestHost=" + requestHost + ", " +
                "RequestPort=" + requestPort +
                "]";
    }


}

