

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex.msg;





import java.net.*;



import phex.*;

import phex.interfaces.*;

import phex.utils.*;





public class MsgUnknown implements IMsg

{

	private MsgHeader	mHeader;

	private byte[]		mBody;

	private String		mBodyStr;





	private MsgUnknown()

	{

	}





	public MsgUnknown(MsgHeader header)

	{

		setHeader(header);

		mBody = null;

	}





	public void setHeader(MsgHeader header)

	{

		mHeader = header;

	}





	public MsgHeader getHeader()

	{

		return mHeader;

	}





	public void setBody(byte[] body)

	{

		mBody = body;

	}





	public byte[] getBody()

	{

		return mBody;

	}









	public void computeHeaderLen()

	{

		mHeader.setDataLen(getSize() - mHeader.getSize());

	}





	public int getSize()

	{

		return mHeader.getSize() + mBody.length;

	}





	public void copy(MsgUnknown b)

	{

		mHeader.copy(b.getHeader());

		mBody = b.mBody;

	}





	public int serialize(byte[] outbuf, int offset)

			throws Exception

	{

		offset = mHeader.serialize(outbuf, offset);

		System.arraycopy(mBody, 0, outbuf, offset, mBody.length);

		offset += mBody.length;



		return offset;

	}





	public int deserialize(byte[] inbuf, int offset)

			throws Exception

	{

		// Already read the header.

		mBody = new byte[mHeader.getDataLen()];

		System.arraycopy(inbuf, offset, mBody, 0, mBody.length);

		offset += mBody.length;



		StringBuffer	strBuf = new StringBuffer();

		IOUtil.deserializeString(mBody, 0, strBuf);

		mBodyStr = strBuf.toString();



		return offset;

	}







	public String toString()

	{

		return	"[" +

				mHeader + ", " +

				mBodyStr +

				"]";

	}





}



