/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.utils;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.Collections;
import java.util.Collection;
import java.util.AbstractMap;

public class JDKUtils
{
    /**
     * The empty map (immutable).  This map is serializable.
     * JDK support since 1.3 ( Collections.EMPTY_MAP )
     */
    public static final Map EMPTY_MAP = new PhexEmptyMap();

    /**
     * JDK support since 1.3 ( Collections.EMPTY_MAP )
     */
    private static class PhexEmptyMap extends AbstractMap implements Serializable
    {
        public int size()                          {return 0;}

        public boolean isEmpty()                   {return true;}

        public boolean containsKey(Object key)     {return false;}

        public boolean containsValue(Object value) {return false;}

        public Object get(Object key)              {return null;}

        public Set keySet()                        {return Collections.EMPTY_SET;}

        public Collection values()                 {return Collections.EMPTY_SET;}

        public Set entrySet()                      {return Collections.EMPTY_SET;}

        public boolean equals(Object o)
        {
            return (o instanceof Map) && ((Map)o).size()==0;
        }

        public int hashCode()                      {return 0;}
    }
}