

/*

 *  PHEX - The pure-java Gnutella-servent.

 *  Copyright (C) 2000 William W. Wong

 *  williamw@jps.net

 *

 *  This program is free software; you can redistribute it and/or modify

 *  it under the terms of the GNU General Public License as published by

 *  the Free Software Foundation; either version 2 of the License, or

 *  (at your option) any later version.

 *

 *  This program is distributed in the hope that it will be useful,

 *  but WITHOUT ANY WARRANTY; without even the implied warranty of

 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

 *  GNU General Public License for more details.

 *

 *  You should have received a copy of the GNU General Public License

 *  along with this program; if not, write to the Free Software

 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */





package phex.utils;





import java.io.*;



import phex.*;





public class URLUtil  

{

	private static boolean[]		sNeedEncode;





    static

	{

		sNeedEncode = new boolean[256];



		for (int i = 0; i < 256; i++)

			sNeedEncode[i] = false;



		sNeedEncode['+'] = true;

		sNeedEncode['<'] = true;

		sNeedEncode['>'] = true;

		sNeedEncode['%'] = true;

//		sNeedEncode['/'] = true;

		sNeedEncode['='] = true;

		sNeedEncode['?'] = true;

		sNeedEncode[';'] = true;

//		sNeedEncode[':'] = true;

		sNeedEncode['@'] = true;

		sNeedEncode['&'] = true;

		sNeedEncode['$'] = true;

		sNeedEncode[','] = true;

		sNeedEncode[' '] = true;

    }





    private URLUtil()

	{

		// disable

	}





    public static String encodeURL(String s)

	{

		StringBuffer			encodedStr = new StringBuffer(s.length());

		ByteArrayOutputStream	buf = new ByteArrayOutputStream(4);

		OutputStreamWriter		writer = new OutputStreamWriter(buf);





		for (int i = 0, len = s.length(); i < len; i++)

		{

			char c = s.charAt(i);



			if (sNeedEncode[c])

			{

				try

				{

					writer.write((int)c);

					writer.flush();

				}

				catch(IOException e)

				{

					buf.reset();

					continue;

				}

				byte[] data = buf.toByteArray();

				encodedStr.append('%');

				HexDec.convertBytesToHexString(data, 0, data.length, encodedStr);



				buf.reset();

			}

			else

			{

				encodedStr.append(c);

			}

		}



		return encodedStr.toString();

	}





	public static String decodeURL(String encStr)

			throws Exception

	{

		StringBuffer	buf = new StringBuffer();



		for (int i = 0, len = encStr.length(); i < len; i++)

		{

			char		ch = encStr.charAt(i);



			if (ch == '%')

			{

				buf.append((char)Integer.parseInt(encStr.substring(i+1, i+3), 16));

				i += 2;

			}

			else if (ch == '+')

			{

				buf.append(' ');

			}

			else

			{

				buf.append(ch);

			}

		}



		return new String(buf.toString().getBytes("8859_1"));

	}







	public static void main(String[] args)

	{

		try

		{

			String	enc = encodeURL(args[0]);

			String	dec = decodeURL(enc);



			System.out.println(enc);

			System.out.println(dec);

		}

		catch (Exception e)

		{

			e.printStackTrace();

		}

	}

	



	

}





