/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.xml;

import java.io.*;
import org.apache.crimson.tree.*;
//import com.sun.xml.tree.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * Helper class to create, generate and parse a xml Document from various
 * resources.
 * @author Gregor Koukkoullis
 */
public class XMLBuilder
{
    private static final DocumentBuilder documentBuilder;

    static
    {
        try
        {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch ( ParserConfigurationException exp )
        {
            exp.printStackTrace();
            throw new RuntimeException( exp.getMessage() );
        }
    }

    public static XmlDocument createNewDocument()
    {
        return (XmlDocument) documentBuilder.newDocument();
    }

    public static Document loadFromSystemResource(String name)
    {
        InputStream stream = ClassLoader.getSystemResourceAsStream(name);
        if (stream == null)
        {
            return null;
        }
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        return loadFromStream(bufferedStream);
    }

    public static Document loadFromResource( String resourceName )
    {
        InputStream stream =
            XMLBuilder.class.getResourceAsStream( resourceName );
        if ( stream != null )
        {
            BufferedInputStream bStream = new BufferedInputStream( stream );
            return loadFromStream( bStream );
        }
        else
        {
            System.out.println( "Can't find resource: " + resourceName + ".");
            return null;
        }
    }

    public static Document loadFromFile(File aFile)
    {
        try
        {
            FileInputStream stream = new FileInputStream( aFile );
            if (stream == null)
            {
                return null;
            }
            BufferedInputStream bufferedStream = new BufferedInputStream(stream);
            return loadFromStream(bufferedStream);
        }
        catch (FileNotFoundException exp)
        {
            return null;
        }
    }

    public static Document loadFromStream(InputStream stream)
    {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try
        {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(stream);
        }
        catch (SAXParseException exp)
        {
            // TODO tracing
            exp.printStackTrace();
            //Trace.error(exp.getException());
        }
        catch (Exception exp)
        {
            exp.printStackTrace();
            System.out.println(exp);
            // TODO tracing
            //Trace.error(exp);
        }
        return null;
    }
}
