/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
// ========================================================================
// File: XMLPhexXMLCodec.java
// Generated by xgen Code Generator from Gregor Koukkoullis.
// Copyright (c) 2001, all rights reserved.
// ========================================================================

package phex.xml;

import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.apache.crimson.tree.*;
import java.util.*;
import java.io.*;
import java.lang.reflect.*;

// This class is generated by xgen Code Generator from Gregor Koukkoullis.
// Do NOT edit this class.

public abstract class XMLPhexXMLCodec
{
    public static XmlDocument encodeXML(XMLPhex object )
    {
        XmlDocument doc = XMLBuilder.createNewDocument();
        encodeXML( object, doc, doc );
        return doc;
    }

    public static void encodeXML(XMLPhex object, Node parentNode, Document doc )
    {
        Element topElem = doc.createElement( "phex" );
        parentNode.appendChild( topElem );

        Object phexVersion = object.getPhexVersion();
        if ( phexVersion != null )
        {
            String s = phexVersion.toString();
            if ( s.length() > 0 )
            {
                Element phexVersionElm = doc.createElement( "phex-version" );
                phexVersionElm.appendChild( doc.createTextNode( s ) );
                topElem.appendChild( phexVersionElm );
            }
        }

        phex.xml.XMLDownloadList downloadList = object.getDownloadList();
        if ( downloadList != null )
        {
            phex.xml.XMLDownloadListXMLCodec.encodeXML( downloadList, topElem, doc );
        }

        phex.xml.XMLResearchServiceConfig researchServiceConfig = object.getResearchServiceConfig();
        if ( researchServiceConfig != null )
        {
            phex.xml.XMLResearchServiceConfigXMLCodec.encodeXML( researchServiceConfig, topElem, doc );
        }

    }

    public static XMLPhex decodeXML( Element root )
    {
        // create new instance
        XMLPhex instance = new XMLPhex();

        NodeList phexVersionList = root.getChildNodes();
        int lengthphexVersion = phexVersionList.getLength();
        for (int i = 0; i < lengthphexVersion; i++ )
        {
            Node phexVersion = phexVersionList.item( i );
            if ( phexVersion != null && phexVersion.getNodeType() == Node.ELEMENT_NODE &&
                 phexVersion.getNodeName().equals( "phex-version" ) )
            {
                String phexVersionValue = getText( (Element)phexVersion);
                instance.setPhexVersion( phexVersionValue );
                break;
            }
        }

        NodeList downloadListList = root.getChildNodes();
        int lengthdownloadList = downloadListList.getLength();
        for (int i = 0; i < lengthdownloadList; i++ )
        {
            Node downloadList = downloadListList.item( i );
            if ( downloadList != null && downloadList.getNodeType() == Node.ELEMENT_NODE &&
                 downloadList.getNodeName().equals( "downloadlist" ) )
            {
                instance.setDownloadList( XMLDownloadListXMLCodec.decodeXML( (Element) downloadList ) );
                break;
            }
        }

        NodeList researchServiceConfigList = root.getChildNodes();
        int lengthresearchServiceConfig = researchServiceConfigList.getLength();
        for (int i = 0; i < lengthresearchServiceConfig; i++ )
        {
            Node researchServiceConfig = researchServiceConfigList.item( i );
            if ( researchServiceConfig != null && researchServiceConfig.getNodeType() == Node.ELEMENT_NODE &&
                 researchServiceConfig.getNodeName().equals( "research-service-config" ) )
            {
                instance.setResearchServiceConfig( XMLResearchServiceConfigXMLCodec.decodeXML( (Element) researchServiceConfig ) );
                break;
            }
        }

        return instance;
    }

    /**
     * This method is here to be more performent. It can be inlined
     * during optimized compilation.
     */
    private static String getText( Node node )
    {
        if (node == null)
        {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; i++)
        {
            Node subNode = nodeList.item(i);
            int type = subNode.getNodeType();
            if (type == Node.TEXT_NODE)
            {
                strBuffer.append(subNode.getNodeValue());
            }
            else if (type == Node.ENTITY_REFERENCE_NODE)
            {
                // The content is in the TEXT node under it
                strBuffer.append( getText( subNode ) );
            }
        }
        return strBuffer.toString();
    }

}
