/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 Gregor Koukkoullis ( phex@kouk.de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
// ========================================================================
// File: XMLResearchServiceConfigXMLCodec.java
// Generated by xgen Code Generator from Gregor Koukkoullis.
// Copyright (c) 2001, all rights reserved.
// ========================================================================

package phex.xml;

import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.apache.crimson.tree.*;
import java.util.*;
import java.io.*;
import java.lang.reflect.*;

// This class is generated by xgen Code Generator from Gregor Koukkoullis.
// Do NOT edit this class.

public abstract class XMLResearchServiceConfigXMLCodec
{
    public static XmlDocument encodeXML(XMLResearchServiceConfig object )
    {
        XmlDocument doc = XMLBuilder.createNewDocument();
        encodeXML( object, doc, doc );
        return doc;
    }

    public static void encodeXML(XMLResearchServiceConfig object, Node parentNode, Document doc )
    {
        Element topElem = doc.createElement( "research-service-config" );
        parentNode.appendChild( topElem );

        Element minRemoteCandidatesCountElm = doc.createElement( "min-remote-candidates-count" );
        minRemoteCandidatesCountElm.appendChild( doc.createTextNode( String.valueOf( object.getMinRemoteCandidatesCount() ) ) );
        topElem.appendChild( minRemoteCandidatesCountElm );

        Element researchIntervalMillisElm = doc.createElement( "research-interval-millis" );
        researchIntervalMillisElm.appendChild( doc.createTextNode( String.valueOf( object.getResearchIntervalMillis() ) ) );
        topElem.appendChild( researchIntervalMillisElm );

        Element maxResearchIntervalMillisElm = doc.createElement( "max-research-interval-millis" );
        maxResearchIntervalMillisElm.appendChild( doc.createTextNode( String.valueOf( object.getMaxResearchIntervalMillis() ) ) );
        topElem.appendChild( maxResearchIntervalMillisElm );

        Element researchTimeoutElm = doc.createElement( "research-timeout" );
        researchTimeoutElm.appendChild( doc.createTextNode( String.valueOf( object.getResearchTimeout() ) ) );
        topElem.appendChild( researchTimeoutElm );

        Element researchEnabledElm = doc.createElement( "research-enabled" );
        researchEnabledElm.appendChild( doc.createTextNode( String.valueOf( object.getResearchEnabled() ) ) );
        topElem.appendChild( researchEnabledElm );

    }

    public static XMLResearchServiceConfig decodeXML( Element root )
    {
        // create new instance
        XMLResearchServiceConfig instance = new XMLResearchServiceConfig();

        NodeList minRemoteCandidatesCountList = root.getChildNodes();
        int lengthminRemoteCandidatesCount = minRemoteCandidatesCountList.getLength();
        for (int i = 0; i < lengthminRemoteCandidatesCount; i++ )
        {
            Node minRemoteCandidatesCount = minRemoteCandidatesCountList.item( i );
            if ( minRemoteCandidatesCount != null && minRemoteCandidatesCount.getNodeType() == Node.ELEMENT_NODE &&
                 minRemoteCandidatesCount.getNodeName().equals( "min-remote-candidates-count" ) )
            {
                String minRemoteCandidatesCountValue = getText( (Element)minRemoteCandidatesCount);
                instance.setMinRemoteCandidatesCount( Integer.parseInt( minRemoteCandidatesCountValue ) );
                break;
            }
        }

        NodeList researchIntervalMillisList = root.getChildNodes();
        int lengthresearchIntervalMillis = researchIntervalMillisList.getLength();
        for (int i = 0; i < lengthresearchIntervalMillis; i++ )
        {
            Node researchIntervalMillis = researchIntervalMillisList.item( i );
            if ( researchIntervalMillis != null && researchIntervalMillis.getNodeType() == Node.ELEMENT_NODE &&
                 researchIntervalMillis.getNodeName().equals( "research-interval-millis" ) )
            {
                String researchIntervalMillisValue = getText( (Element)researchIntervalMillis);
                instance.setResearchIntervalMillis( Long.parseLong( researchIntervalMillisValue ) );
                break;
            }
        }

        NodeList maxResearchIntervalMillisList = root.getChildNodes();
        int lengthmaxResearchIntervalMillis = maxResearchIntervalMillisList.getLength();
        for (int i = 0; i < lengthmaxResearchIntervalMillis; i++ )
        {
            Node maxResearchIntervalMillis = maxResearchIntervalMillisList.item( i );
            if ( maxResearchIntervalMillis != null && maxResearchIntervalMillis.getNodeType() == Node.ELEMENT_NODE &&
                 maxResearchIntervalMillis.getNodeName().equals( "max-research-interval-millis" ) )
            {
                String maxResearchIntervalMillisValue = getText( (Element)maxResearchIntervalMillis);
                instance.setMaxResearchIntervalMillis( Long.parseLong( maxResearchIntervalMillisValue ) );
                break;
            }
        }

        NodeList researchTimeoutList = root.getChildNodes();
        int lengthresearchTimeout = researchTimeoutList.getLength();
        for (int i = 0; i < lengthresearchTimeout; i++ )
        {
            Node researchTimeout = researchTimeoutList.item( i );
            if ( researchTimeout != null && researchTimeout.getNodeType() == Node.ELEMENT_NODE &&
                 researchTimeout.getNodeName().equals( "research-timeout" ) )
            {
                String researchTimeoutValue = getText( (Element)researchTimeout);
                instance.setResearchTimeout( Long.parseLong( researchTimeoutValue ) );
                break;
            }
        }

        NodeList researchEnabledList = root.getChildNodes();
        int lengthresearchEnabled = researchEnabledList.getLength();
        for (int i = 0; i < lengthresearchEnabled; i++ )
        {
            Node researchEnabled = researchEnabledList.item( i );
            if ( researchEnabled != null && researchEnabled.getNodeType() == Node.ELEMENT_NODE &&
                 researchEnabled.getNodeName().equals( "research-enabled" ) )
            {
                String researchEnabledValue = getText( (Element)researchEnabled);
                instance.setResearchEnabled( Boolean.valueOf( researchEnabledValue ).booleanValue() );
                break;
            }
        }

        return instance;
    }

    /**
     * This method is here to be more performent. It can be inlined
     * during optimized compilation.
     */
    private static String getText( Node node )
    {
        if (node == null)
        {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; i++)
        {
            Node subNode = nodeList.item(i);
            int type = subNode.getNodeType();
            if (type == Node.TEXT_NODE)
            {
                strBuffer.append(subNode.getNodeValue());
            }
            else if (type == Node.ENTITY_REFERENCE_NODE)
            {
                // The content is in the TEXT node under it
                strBuffer.append( getText( subNode ) );
            }
        }
        return strBuffer.toString();
    }

}
