/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000 Kevin P. Lawton
 *
 *  ctrl_xfer8.c:  emulation of 8-bit control transfer instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"


  void
LOOPNE_Jb(vm_t *vm)
{
  Bit32u count, new_EIP;
 
  if (vm->i.as_32)
    count = G_ECX(vm);
  else
    count = G_CX(vm);
 
  count--;
  if ( (count != 0) && (G_GetZF(vm)==0) ) {
 
    new_EIP = G_EIP(vm) + (Bit32s) vm->i.Id;
    if (vm->i.os_32==0)
      new_EIP &= 0x0000ffff;
    if (ProtectedMode(vm)) {
      cache_sreg(vm, SRegCS);
      if (new_EIP > vm->guest_cpu.desc_cache[SRegCS].limit_scaled) {
        monpanic(vm, "loop_jb: offset outside of CS limits\n");
        exception(vm, ExceptionGP, 0);
        }
      }
    G_EIP(vm) = new_EIP;
    revalidate_prefetch_q();
    }
 
  if (vm->i.as_32)
    G_ECX(vm)--;
  else
    G_CX(vm)--;
}

  void
LOOPE_Jb(vm_t *vm)
{
  Bit32u count, new_EIP;
 
  if (vm->i.as_32)
    count = G_ECX(vm);
  else
    count = G_CX(vm);
 
  count--;
  if ( (count != 0) && G_GetZF(vm) ) {
 
    new_EIP = G_EIP(vm) + (Bit32s) vm->i.Id;
    if (vm->i.os_32==0)
      new_EIP &= 0x0000ffff;
    if (ProtectedMode(vm)) {
      cache_sreg(vm, SRegCS);
      if (new_EIP > vm->guest_cpu.desc_cache[SRegCS].limit_scaled) {
        monpanic(vm, "loop_jb: offset outside of CS limits\n");
        exception(vm, ExceptionGP, 0);
        }
      }
    G_EIP(vm) = new_EIP;
    revalidate_prefetch_q();
    }
 
  if (vm->i.as_32)
    G_ECX(vm)--;
  else
    G_CX(vm)--;
}


  void
LOOP_Jb(vm_t *vm)
{
  Bit32u count, new_EIP;
 
  if (vm->i.as_32)
    count = G_ECX(vm);
  else
    count = G_CX(vm);
 
  count--;
  if (count != 0) {
 
    new_EIP = G_EIP(vm) + (Bit32s) vm->i.Id;
    if (vm->i.os_32==0)
      new_EIP &= 0x0000ffff;
    if (ProtectedMode(vm)) {
      cache_sreg(vm, SRegCS);
      if (new_EIP > vm->guest_cpu.desc_cache[SRegCS].limit_scaled) {
        monpanic(vm, "loop_jb: offset outside of CS limits\n");
        exception(vm, ExceptionGP, 0);
        }
      }
    G_EIP(vm) = new_EIP;
    revalidate_prefetch_q();
    }
 
  if (vm->i.as_32)
    G_ECX(vm)--;
  else
    G_CX(vm)--;
}

  void
JCXZ_Jb(vm_t *vm)
{
  Bit32u temp_ECX;
 
  if (vm->i.as_32)
    temp_ECX = G_ECX(vm);
  else
    temp_ECX = G_CX(vm);
 
  if ( temp_ECX == 0 ) {
    Bit32u new_EIP;
 
    new_EIP = G_EIP(vm) + (Bit32s) vm->i.Id;
    if (vm->i.os_32==0)
      new_EIP &= 0x0000ffff;
    if (ProtectedMode(vm)) {
      cache_sreg(vm, SRegCS);
      if (new_EIP > vm->guest_cpu.desc_cache[SRegCS].limit_scaled) {
        monpanic(vm, "jcxz_jb: offset outside of CS limits\n");
        exception(vm, ExceptionGP, 0);
        }
      }
    G_EIP(vm) = new_EIP;
    revalidate_prefetch_q();
    }
}
