/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000 Kevin P. Lawton
 *
 *  data_xfer8.c:  emulation of 8-bit data transfer instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"


  void
MOV_GbEb(vm_t *vm)
{
  Bit8u op2_8;

  if (vm->i.mod == 0xc0) {
    op2_8 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2_8);
    }

  WriteReg8(vm, vm->i.nnn, op2_8);
}

  void
MOV_EbGb(vm_t *vm)
{
  Bit8u op2;

  op2 = ReadReg8(vm, vm->i.nnn);

  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op2);
    }
  else {
    write_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
}

  void
MOV_EbIb(vm_t *vm)
{
  Bit8u op2;
 
  op2 = vm->i.Ib;
 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op2);
    }
  else {
    write_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
}

  void
MOV_ObAL(vm_t *vm)
{
  Bit8u  temp_8;
  Bit32u addr_32;

  addr_32 = vm->i.Id;

  /* read from register */
  temp_8 = G_AL(vm);

  /* write to memory address */
  if (!NULL_SEG_REG(vm->i.seg)) {
    write_virtual_byte(vm, vm->i.seg, addr_32, &temp_8);
    }
  else {
    write_virtual_byte(vm, SRegDS, addr_32, &temp_8);
    }
}

  void
MOV_ALOb(vm_t *vm)
{
  Bit8u  temp_8;
  Bit32u addr_32;
 
  addr_32 = vm->i.Id;
 
  if (!NULL_SEG_REG(vm->i.seg)) {
    read_virtual_byte(vm, vm->i.seg, addr_32, &temp_8);
    }
  else {
    read_virtual_byte(vm, SRegDS, addr_32, &temp_8);
    }
 
 
  G_AL(vm) = temp_8;
}

  void
XCHG_EbGb(vm_t *vm)
{
  Bit8u op2, op1;
 
  op2 = ReadReg8(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    WriteReg8(vm, vm->i.rm, op2);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    write_RMW_virtual_byte(vm, &op2);
    }
 
  WriteReg8(vm, vm->i.nnn, op1);
}

  void
XLAT(vm_t *vm)
{
  Bit32u offset_32;
  Bit8u  al;
 
  if (vm->i.as_32) {
    offset_32 = G_EBX(vm) + G_AL(vm);
    }
  else {
    offset_32 = G_BX(vm) + G_AL(vm);
    }
 
  if ( !NULL_SEG_REG(vm->i.seg) ) {
    read_virtual_byte(vm, vm->i.seg, offset_32, &al);
    }
  else {
    read_virtual_byte(vm, SRegDS, offset_32, &al);
    }
  G_AL(vm) = al;
}
