/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000 Kevin P. Lawton
 *
 *  flag.c:  x86 eflags oriented instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"

  void
POPF_Fv(vm_t *vm)
{
  Bit32u eflags, change_mask;
  unsigned prevIF;

  prevIF = G_GetIF(vm);

  if (V8086Mode(vm)) {
    if (G_FLG_IOPL(vm) < 3) {
      exception(vm, ExceptionGP, 0);
      }
    if (vm->i.os_32) {
      monpanic(vm, "popf_fv: os_32\n");
      exception(vm, ExceptionGP, 0);
      }
    }

  if (vm->i.os_32) {

    pop32(vm, &eflags);

    change_mask = 0x00244dd5;
    if (!RealMode(vm)) {
      if (G_CPL(vm)==0)              change_mask |= 0x00003000; /* IOPL */
      if (G_CPL(vm)<=G_FLG_IOPL(vm)) change_mask |= 0x00000200; /* IF */
      }
    else { /* real mode */
      change_mask |= 0x00003200; /* IOPL,IF */
      }
    /* VM,RF are not changed */
    }
  else { /* 16 bit opsize */
    Bit16u flags;

    pop16(vm, &flags);
    eflags = flags;

    change_mask = 0x00004dd5;
    if (!RealMode(vm)) {
      if (G_CPL(vm)==0)              change_mask |= 0x00003000; /* IOPL */
      if (G_CPL(vm)<=G_FLG_IOPL(vm)) change_mask |= 0x00000200; /* IF */
      }
    else {
      change_mask |= 0x00003200; /* IOPL,IF */
      }
    }
  write_eflags(vm, eflags, change_mask);
  /* +++ does POPF do this? */
  if (!prevIF && G_GetIF(vm)) {
    vm->guest_cpu.inhibit_mask |= INHIBIT_INTERRUPTS;
    vm->guest_cpu.async_event = 1;
    }
/*monprint(vm, "POPF: image=0x%x, IF=%u\n", eflags, G_GetIF(vm)); */
  /* +++ does this inhibit ints like STI does? */
}

  void
PUSHF_Fv(vm_t *vm)
{
  if (V8086Mode(vm) && (G_FLG_IOPL(vm)<3)) {
    exception(vm, ExceptionGP, 0);
    }

  if (vm->i.os_32) {
    push32(vm, read_eflags(vm) & 0x00fcffff);
    }
  else {
    push16(vm, (Bit16u) read_eflags(vm));
    }
}

  void
LAHF(vm_t *vm)
{
  G_AH(vm) = (Bit8u) read_eflags(vm);
}

  void
SAHF(vm_t *vm)
{
  Bit32u eflags;

  eflags = G_AH(vm);
  SetSZAPC(vm, eflags);
}

 void
CMC(vm_t *vm)
{
  G_SetCF(vm, !G_GetCF(vm) );
}

  void
SALC(vm_t *vm)
{
  if ( G_GetCF(vm) ) {
    G_AL(vm) = 0xff;
    }
  else {
    G_AL(vm) = 0x00;
    }
}
