/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000  Kevin P. Lawton
 *
 *  fetchdecode.h: Header file for x86 instruction fetch/decode logic
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __FETCHDECODE_H__
#define __FETCHDECODE_H__


typedef struct instruction_tag {
  /* prefix stuff here... */
  unsigned attr; /* attribute from fetchdecode */
  unsigned b1; /* opcode1 byte */
  unsigned rep_used;
  unsigned modrm; /* mod-nnn-r/m byte */
    unsigned mod;
    unsigned nnn;
    unsigned rm;
  Bit16u displ16u; /* for 16-bit modrm forms */
  Bit32u displ32u; /* for 32-bit modrm forms */
  unsigned seg;
  unsigned sib; /* scale-index-base (2nd modrm byte) */
    unsigned scale;
    unsigned index;
    unsigned base;
  Bit32u   addr_displacement; /* address displacement */
  Bit32u   rm_addr;
  Bit32u   Id;
  Bit16u   Iw;
  Bit8u    Ib;
  Bit8u    Ib2; /* for ENTER_IwIb */
  Bit16u   Iw2; /* for JMP_Ap */
  unsigned ilen; /* instruction length */
  unsigned os_32, as_32; /* OperandSize/AddressSize is 32bit */
  void (*ResolveModrm)(struct instruction_tag *i, guest_context_t *);
  } instruction_t;


unsigned fetchDecode(Bit8u *iptr, instruction_t *instruction,
                      unsigned remain, Boolean is_32);


#define NumGroups       16

#define GetGroupIndex(attr) (((attr) >> 12) & 0x0f)
#define PutGroupIndex(index) ((index) << 12)

#define G1EbIb 0
#define G1Ew   1
#define G1Ed   2
#define G2Eb   3
#define G2Ew   4
#define G2Ed   5
#define G3Eb   6
#define G3Ew   7
#define G3Ed   8
#define G4     9
#define G5w    10
#define G5d    11
#define G6     12
#define G7     13
#define G8EvIb 14
#define G9     15


#define SEG_REG_ES    0
#define SEG_REG_CS    1
#define SEG_REG_SS    2
#define SEG_REG_DS    3
#define SEG_REG_FS    4
#define SEG_REG_GS    5
#define SEG_REG_NULL  8
#define NULL_SEG_REG(seg) ((seg) & SEG_REG_NULL)

/* Same as above */
#define SRegES 0
#define SRegCS 1
#define SRegSS 2
#define SRegDS 3
#define SRegFS 4
#define SRegGS 5

#define RegEAX 0
#define RegECX 1
#define RegEDX 2
#define RegEBX 3
#define RegESP 4
#define RegEBP 5
#define RegESI 6
#define RegEDI 7

/* */
/* Definitions for decoding immediate data following opcodes */
/* */
#define Immediate         0x000f /* bits 3..0: any immediate */
#define Immediate_Ib      0x0001 /* 8 bits regardless */
#define Immediate_Ib_SE   0x0002 /* sign extend to OS size */
#define Immediate_Iv      0x0003 /* 16 or 32 depending on OS size */
#define Immediate_Iw      0x0004 /* 16 bits regardless */
#define Immediate_IvIw    0x0005 /* call_Ap */
#define Immediate_IwIb    0x0006 /* enter_IwIb */
#define Immediate_O       0x0007 /* mov_ALOb, mov_ObAL, mov_eAXOv, mov_OveAX */
#define Immediate_BrOff8  0x0008 /* Relative branch offset byte */
#define Immediate_BrOff16 0x0009 /* Relative branch offset word */
#define Immediate_BrOff32 0x000A /* Relative branch offset dword */

#define Prefix            0x0010
#define Another           0x0020
#define Repeatable        0x0040
#define RepeatableZF      0x0080
#define GroupN            0x0100
#define UCBranch          0x0200 /* UnConditional Branch */
#define InvalidOpcode     0x0400
/* bit11 unused */

/* Bits 15..12 used by group number above */


#define MaxIA32OpcodeLen 15


#endif /* __FETCHDECODE_H__ */
