inline Bit8u inportb(Bit16u port)
{
    Bit8u ret;

    asm volatile ("inb (%%dx),%%al":"=a" (ret):"d" (port));
    return ret;
}


inline Bit16u inportw(Bit16u port)
{
    Bit16u ret;

    asm volatile ("inw (%%dx),%%ax":"=a" (ret):"d" (port));
    return ret;
}

inline void outportb(Bit16u port, Bit8u value)
{
    asm volatile ("outb %%al,(%%dx)"::"d" (port), "a" (value));
}


inline void outportw(Bit16u port, Bit16u value)
{
    asm volatile ("outw %%ax,%%dx"::"d" (port), "a" (value));
}


/* Delayed port functions */

inline Bit8u dinportb(Bit16u port)
{
    Bit8u ret;

    asm volatile ("inb (%%dx),%%al;outb %%al,$0x80":"=a" (ret):"d" (port));
    return ret;
}


inline Bit16u dinportw(Bit16u port)
{
    Bit16u ret;

    asm volatile ("inw (%%dx),%%ax;outb %%al,$0x80":"=a" (ret):"d" (port));
    return ret;
}


inline void doutportb(Bit16u port, Bit8u value)
{
    asm volatile ("outb %%al,(%%dx);outb %%al,$0x80"::"d" (port), "a" (value));
}


inline void doutportw(Bit16u port, Bit16u value)
{
    asm volatile ("outw %%ax,%%dx;outb %%al,$0x80"::"d" (port), "a" (value));
}
