/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000  Kevin P. Lawton
 *
 *  prescan.h: Header file for scan-before-execute logic.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __PRESCAN_H__
#define __PRESCAN_H__

#include "fetchdecode.h"


#define INT3OP 0xcc



/* ================================================================= */
/* Bit definititions for elements in vOpcodeMap_t. */
/* Bit4: signals if this instruction needs virtualization */
/*      0: virtualize this instruction */
/*      1: well behaved; no need to virtualize */
#define OpcodeRunNative      0x10 /* used for instruction meta cache also */

/* Shorthand macro */
#define RN OpcodeRunNative


/* ================================================================= */
/* Bit definitions for fields in instruction meta cache. */
/*   3..0: instruction length (1..15) */
/*      4: run native;   1=run native, 0=virtualize */
/*      5: available:    (not used) */
/*      6: opcode-byte:  1=instruction opcode byte, 0=not */
/*      7: opcode-start: 1=scanned instruction starts here, 0=not */

#define MetaGetILen(m)     ((m) & 0x0f)
#define MetaRunNative      OpcodeRunNative
#define MetaOpcodeByte     0x40
#define MetaOpcodeStart    0x80

#endif /* __PRESCAN_H__ */
