/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  rom.c: load a ROM image into VM memory.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "plex86.h"
#include "user.h"



  int
load_rom(int argc, char *argv[])
{
  char *address_p, *filename_p;
  Bit32u address;
  /*unsigned long bin_size; */
  struct stat stat_buf;
  int fileno;
  unsigned char *image;


#define FILE_PARAM    "file="
#define ADDRESS_PARAM "address="

  if (argc != 2)
    goto usage;
  if ( !argv[0] || strncmp(argv[0], FILE_PARAM, strlen(FILE_PARAM)) )
    goto usage;
  filename_p = &argv[0][strlen(FILE_PARAM)];
  if ( !argv[1] || strncmp(argv[1], ADDRESS_PARAM, strlen(ADDRESS_PARAM)) )
    goto usage;
  address_p  = &argv[1][strlen(ADDRESS_PARAM)];
  address = strtoul(address_p, NULL, 0);

  fileno = open(filename_p, O_RDONLY);
  if (fileno < 0) {
    fprintf(stderr, "rom: open %s: %s\n", filename_p, strerror(errno));
    return 1;
    }
  if (fstat(fileno, &stat_buf) != 0) {
    fprintf(stderr, "rom: fstat %s: %s\n", filename_p, strerror(errno));
    return 1;
    }

  fprintf(stderr, "ROM: loading image '%s' @ 0x%x (%u bytes)\n",
    filename_p, address, (unsigned) stat_buf.st_size);

  if ((image = (void *) malloc (stat_buf.st_size)) == NULL) {
    perror("rom: malloc");
    return 1;
    }
  if (read (fileno, image, stat_buf.st_size) != stat_buf.st_size) {
    perror ("rom: read");
    return 1;
    }
  close(fileno);

  if (vm_write_physical(address, stat_buf.st_size, image)) {
    fprintf (stderr, "rom: trying to load beyond available VM memory.\n");
    return 1;
    }

  free(image);

  return 0;

usage:
  fprintf(stderr, "usage: load-rom file=xyz address=xyz\n");
  return 1;
}
