/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000 Kevin P. Lawton
 *
 *  logical16.c:  16-bit logical instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"


  void
TEST_AXIw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op1 = G_AX(vm);
  op2 = vm->i.Iw;
 
  asm volatile (
    "testw %2, %1 \n\t"
    "pushfl       \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "r" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}

  void
XOR_GwEw(vm_t *vm)
{
  Bit16u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg16(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "xorw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  WriteReg16(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}

  void
NOT_Ew(vm_t *vm)
{
  Bit16u op1;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  op1 = ~op1;
 
  if (vm->i.mod == 0xc0) {
    WriteReg16(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_word(vm, &op1);
    }
}

  void
OR_EwIw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Iw;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "orw %3, %1  \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg16(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_word(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
OR_AXIw(vm_t *vm)
{
  Bit16u op1, op2;
  Bit32u eflags;
 
  op1 = G_AX(vm);
  op2 = vm->i.Iw;
 
  asm volatile (
    "orw  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  G_AX(vm) = op1;
 
  SetOSZAPC(vm, eflags);
}

  void
OR_EwGw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg16(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "orw  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg16(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_word(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
XOR_AXIw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op1 = G_AX(vm);
  op2 = vm->i.Iw;
 
  asm volatile (
    "xorw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  G_AX(vm) = op1;
  SetOSZAPC(vm, eflags);
}

  void
XOR_EwIw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Iw;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "xorw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg16(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_word(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
AND_AXIw(vm_t *vm)
{
  Bit16u op1, op2;
  Bit32u eflags;
 
  op1 = G_AX(vm);
  op2 = vm->i.Iw;
 
  asm volatile (
    "andw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  G_AX(vm) = op1;
 
  SetOSZAPC(vm, eflags);
}

  void
AND_EwIw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Iw;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "andw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg16(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_word(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
AND_EwGw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg16(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "andw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg16(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_word(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
AND_GwEw(vm_t *vm)
{
  Bit16u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg16(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "andw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  WriteReg16(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}


  void
XOR_EwGw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg16(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "xorw %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg16(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_word(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
TEST_EwIw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Iw;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }

  asm volatile (
    "testw %2, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "r" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}

  void
TEST_EwGw(vm_t *vm)
{
  Bit16u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg16(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "testw %2, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "r" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}

  void
OR_GwEw(vm_t *vm)
{
  Bit16u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg16(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "orw  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  WriteReg16(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}
