/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000 Kevin P. Lawton
 *
 *  logical32.c:  32-bit logical instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"

  void
OR_EdId(vm_t *vm)
{
  Bit32u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Id;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "orl  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg32(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_dword(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
XOR_EdId(vm_t *vm)
{
  Bit32u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Id;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "xorl  %3, %1 \n\t"
    "pushfl       \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg32(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_dword(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}


  void
TEST_EAXId(vm_t *vm)
{
  Bit32u op2, op1;
  Bit32u eflags;
 
  op1 = G_EAX(vm);
  op2 = vm->i.Id;
 
  asm volatile (
    "testl %2, %1 \n\t"
    "pushfl       \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "r" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}

  void
TEST_EdId(vm_t *vm)
{
  Bit32u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Id;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }

  asm volatile (
    "testl %2, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "r" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}

  void
XOR_GdEd(vm_t *vm)
{
  Bit32u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg32(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "xorl  %3, %1 \n\t"
    "pushfl       \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  WriteReg32(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}

  void
OR_EdGd(vm_t *vm)
{
  Bit32u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg32(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "orl  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg32(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_dword(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
OR_GdEd(vm_t *vm)
{
  Bit32u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg32(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "orl  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  WriteReg32(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}

  void
OR_EAXId(vm_t *vm)
{
  Bit32u op1, op2, eflags;

  op1 = G_EAX(vm);
  op2 = vm->i.Id;

  asm volatile (
    "orl  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );

  G_EAX(vm) = op1;
  SetOSZAPC(vm, eflags);
}

  void
TEST_EdGd(vm_t *vm)
{
  Bit32u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg32(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "testl %2, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "r" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}

  void
AND_EdGd(vm_t *vm)
{
  Bit32u op2, op1, eflags;
 
  op2 = ReadReg32(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "andl %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg32(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_dword(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
AND_EdId(vm_t *vm)
{
  Bit32u op2, op1, eflags;

  op2 = vm->i.Id;

  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }

  asm volatile (
    "andl %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );

  if (vm->i.mod == 0xc0) {
    WriteReg32(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_dword(vm, &op1);
    }

  SetOSZAPC(vm, eflags);
}

  void
AND_EAXId(vm_t *vm)
{
  Bit32u op1, op2;
  Bit32u eflags;
 
  op1 = G_EAX(vm);
  op2 = vm->i.Id;
 
  asm volatile (
    "andl %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  G_EAX(vm) = op1;
  SetOSZAPC(vm, eflags);
}

  void
AND_GdEd(vm_t *vm)
{
  Bit32u op1, op2, eflags;
 
  op1 = ReadReg32(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "andl %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  WriteReg32(vm, vm->i.nnn, op1);
  SetOSZAPC(vm, eflags);
}

  void
XOR_EdGd(vm_t *vm)
{
  Bit32u op2, op1, eflags;
 
  op2 = ReadReg32(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "xorl %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg32(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_dword(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
XOR_EAXId(vm_t *vm)
{
  Bit32u op1, op2, eflags;

  op1 = G_EAX(vm);
  op2 = vm->i.Id;

  asm volatile (
    "xorl %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=r" (op1)
    : "1" (op1), "g" (op2)
    : "memory", "cc"
    );
 
  G_EAX(vm) = op1;
  SetOSZAPC(vm, eflags);
}

  void
NOT_Ed(vm_t *vm)
{
  Bit32u op1;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg32(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  op1 = ~op1;
 
  if (vm->i.mod == 0xc0) {
    WriteReg32(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_dword(vm, &op1);
    }
}
