/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000 Kevin P. Lawton
 *
 *  soft_int.c:  software interrupt instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"


  void
INT3(vm_t *vm)
{
  /* INT 3 is not IOPL sensitive */

  interrupt(vm, 3, 1, 0, 0);
}


  void
INT_Ib(vm_t *vm)
{
  Bit8u imm8;

  imm8 = vm->i.Ib;

  if (V8086Mode(vm) && (G_FLG_IOPL(vm)<3)) {
    exception(vm, ExceptionGP, 0);
    }

#if 0
if ( (imm8 == 0x15) && (G_AH(vm)==0x87) ) {
  G_AH(vm) = 0x80;
  vm->guest.addr.guest_context->eflags |= FLG_CF;
  monprint(vm, "INT_Ib: 0x15 AH=0x87: fudging to return error\n");
  return;
  }
#endif

#if USE_LOADER
if ( (imm8 == 0x21) && (G_AH(vm) == 0x4c) ) {
  monprint(vm, "INT 21/4C called AL=0x%02x, BX=0x%04x\n",
            (unsigned) G_AL(vm), (unsigned) G_BX(vm));
  monpanic(vm, "Terminating.\n");
  }
#endif

  interrupt(vm, imm8, 1, 0, 0);
}
