/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000  Kevin P. Lawton
 *
 *  crx.h: Control Register CR0..CR4 definitions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#ifndef __CRX_H__
#define __CRX_H__

typedef union {
  Bit32u raw;
  struct {
    Bit32u pe:1;
    Bit32u mp:1;
    Bit32u em:1;
    Bit32u ts:1;
    Bit32u et:1;
    Bit32u ne:1;
    Bit32u R15_6:10;
    Bit32u wp:1;
    Bit32u R17:1;
    Bit32u am:1;
    Bit32u R28_19:10;
    Bit32u nw:1;
    Bit32u cd:1;
    Bit32u pg:1;
    } __attribute__ ((packed)) fields;
  } __attribute__ ((packed)) cr0_t;

typedef union {
  Bit32u raw;
  struct {
    Bit32u vme:1;
    Bit32u pvi:1;
    Bit32u tsd:1;
    Bit32u de:1;
    Bit32u pse:1;
    Bit32u pae:1;
    Bit32u mce:1;
    Bit32u pge:1;
    Bit32u pce:1;
    Bit32u reserved:23;
    } __attribute__ ((packed)) fields;
  } __attribute__ ((packed)) cr4_t;


#endif  /* #define __CRX_H__ */
