/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  Kevin P. Lawton
 *
 *  vmsetjmp.h: a simple setjmp implementation
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __VMSETJMP_H__
#define __VMSETJMP_H__

#if 0
typedef struct {
  long blah[5];
  } vm_jmp_buf_t;

#define SetJmp(jmp_buf)       __builtin_setjmp(&jmp_buf)
#define LongJmp(jmp_buf, ret) __builtin_longjmp(&jmp_buf,ret)

#else
typedef struct {
  unsigned eip;
  unsigned esp;
  unsigned ebp;
  } vm_jmp_buf_t;
 
#define SetJmp(jmp_buf) \
  ({ \
  unsigned ret; \
  asm volatile ( \
    "movl  $0f,   %0    \n\t" \
    "movl  %%esp, %1    \n\t" \
    "movl  %%ebp, %2    \n\t" \
    "movl  $0x0,  %%eax \n\t" \
    "0: \n" \
    : "=m" (jmp_buf.eip), "=m" (jmp_buf.esp), "=m" (jmp_buf.ebp), \
      "=a" (ret) \
    : \
    : "memory", "ebx", "ecx", "edx", "edi", "esi" \
    ); \
  ret; \
  })
 
#define LongJmp(jmp_buf, ret) \
  asm volatile ( \
    "movl  %%edx, %%ebp \n\t" \
    "movl  %%ebx, %%esp \n\t" \
    "jmpl  *%%ecx       \n" \
    : \
    : "c" (jmp_buf.eip), "b" (jmp_buf.esp), "d" (jmp_buf.ebp), \
      "a" (ret) \
    : "memory" \
    );
#endif

#endif  /* __VMSETJMP_H__ */
