/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2000  Kevin P. Lawton
 *
 *  nexus-prescan.c: SBE related routines and opcode maps which are
 *    accessed from either space.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_NEXUS_SPACE
#include "monitor.h"


/*  Some special cases I've noted for whatever reasons. (Kevin)
 *    push esp, pop esp? 54, 5c
 *    cmov 0f 40..4f
 *    cmpxchg_xbts/ibts 0f a6/a7
 *    cmpxchg_e.g. 0f b0/b1
 *    xadd_e.g. 0f c0/c1
 *    group9 0f c7
 *    bswap_e.x 0f c8..cf
 *    group9 0f c7 nnn=1
 */


vOpcodeMap_t vOpcodeMapStrongest =
{
    {
/******************************* 1-byte opcodes ******************************/
/*            0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F  */
/*****************************************************************************/
/* 00..0F */  RN, RN, RN, RN, RN, RN, 0,  0,  RN, RN, RN, RN, RN, RN, 0,  0,
/* 10..1F */  RN, RN, RN, RN, RN, RN, 0,  0,  RN, RN, RN, RN, RN, RN, 0,  0,
/* 20..2F */  RN, RN, RN, RN, RN, RN, 0,  RN, RN, RN, RN, RN, RN, RN, 0,  RN,
/* 30..3F */  RN, RN, RN, RN, RN, RN, 0,  RN, RN, RN, RN, RN, RN, RN, 0,  RN,
/* 40..4F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* 50..5F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* 60..6F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* 70..7F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* 80..8F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, 0,  0,  0,  RN,
/* 90..9F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, 0,  0,  0,  0,  RN, RN,
/* A0..AF */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* B0..BF */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* C0..CF */  RN, RN, 0,  0,  0,  0,  RN, RN, 0,  0,  0,  0,  0,  0,  0,  0,
/* D0..DF */  RN, RN, RN, RN, RN, RN, RN, RN, 0,  0,  0,  0,  0,  0,  0,  0,
/* E0..EF */  RN, RN, RN, RN, 0,  0,  0,  0,  RN, RN, 0,  RN, 0,  0,  0,  0,
/* F0..FF */  RN, 0,  RN, RN, 0,  RN, RN, RN, RN, RN, 0,  0,  RN, RN, RN, RN,
/*****************************************************************************/

/******************************* 2-byte opcodes ******************************/
/*            0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F  */
/*****************************************************************************/
/* 00..0F */  RN, RN, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 10..1F */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 20..2F */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 30..3F */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 40..4F */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 50..5F */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 60..6F */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70..7F */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 80..8F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* 90..9F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* A0..AF */  0,  0,  0,  RN, RN, RN, 0,  0,  0,  0,  0,  RN, RN, RN, 0,  RN,
/* B0..BF */  0,  0,  0,  RN, 0,  0,  RN, RN, 0,  0,  RN, RN, RN, RN, RN, RN,
/* C0..CF */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* D0..DF */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* E0..EF */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* F0..FF */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*****************************************************************************/
    },
    {
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G1EbIb  */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G1Ew    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G1Ed    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G2Eb    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G2Ew    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G2Ed    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G3Eb    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G3Ew    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G3Ed    */
      { RN, RN, 0,  0,  0,  0,  0,  0  }, /* G4      */
      { RN, RN, 0,  0,  0,  0,  RN, 0  }, /* G5w     */
      { RN, RN, 0,  0,  0,  0,  RN, 0  }, /* G5d     */
      { 0,  0,  0,  0,  0,  0,  0,  0  }, /* G6      */
      { 0,  0,  0,  0,  0,  0,  0,  0  }, /* G7      */
      { 0,  0,  0,  0,  RN, RN, RN, RN }, /* G8EvIb  */
      { 0,  0,  0,  0,  0,  0,  0,  0  }, /* G9      */
    }
};


/* Virtualization opcode maps for various modes which the
 * monitor/guest can be executing in.
 */

/* Strongest virtualization map. */
vOpcodeMap_t vOpcodeMapStrongest;

/* For when guest code is being run in v86 mode. (guest in RM or v86) */
vOpcodeMap_t vOpcodeMapV86;


/* Initialize the virtualized instruction opcode maps.  It is
 * more efficient to have different ones, depending on the mode that
 * the monitor/guest code is executing in.  For example, if the
 * monitor can run guest code in v86 mode, we can allow native
 * execution of instructions which reload segment registers and
 * read selectors.
 */

  void
initPrescan(vm_t *vm)
{
  initVCodeCache(vm);

/* 8D, 9B, 9C, 9D, C8..CF, D8..DF (fpu),
 * E4,E5,E6,E7, EC,ED,EE,EF
 * F1,F4,
 */

  /* Start with stongest map, and weaken */
  copy_memory(&vOpcodeMapV86, &vOpcodeMapStrongest, sizeof(vOpcodeMap_t));

#if COSIMULATE == 0
  vOpcodeMapV86.standard[0x06] = RN; /* PUSH ES */
  vOpcodeMapV86.standard[0x07] = RN; /* POP  ES */
  vOpcodeMapV86.standard[0x0E] = RN; /* PUSH CS */

  vOpcodeMapV86.standard[0x16] = RN; /* PUSH SS */
  vOpcodeMapV86.standard[0x17] = RN; /* POP  SS */
  vOpcodeMapV86.standard[0x1E] = RN; /* PUSH DS */
  vOpcodeMapV86.standard[0x1F] = RN; /* POP  DS */

  vOpcodeMapV86.standard[0x8C] = RN; /* MOV EwSw */
  vOpcodeMapV86.standard[0x8E] = RN; /* MOV SwEw */

  vOpcodeMapV86.standard[0xC4] = RN; /* LES GvMp */
  vOpcodeMapV86.standard[0xC5] = RN; /* LDS GvMp */

  /* Two-byte opcodes, 0F XX */
  vOpcodeMapV86.standard[0x1A0] = RN; /* PUSH FS */
  vOpcodeMapV86.standard[0x1A1] = RN; /* POP  FS */
  vOpcodeMapV86.standard[0x1A8] = RN; /* PUSH GS */
  vOpcodeMapV86.standard[0x1A9] = RN; /* POP  GS */

  vOpcodeMapV86.standard[0x1B2] = RN; /* LSS GvMp */
  vOpcodeMapV86.standard[0x1B4] = RN; /* LFS GvMp */
  vOpcodeMapV86.standard[0x1B5] = RN; /* LGS GvMp */

  /* vOpcodeMapV86.standard[512]; */
  /* vOpcodeMapV86.groups[NG][8]; */
#endif
}


  void
initVCodeCache(vm_t *vm)
{
  unsigned i;
  code_cache_entry_t *cache_entry;
 
  for (i=0; i<ICACHE_PAGES; i++) {
    cache_entry = &vm->code_cache[i];
    cache_entry->ts.guest_executed = 0;
    cache_entry->guest_paddr = 0xffffffff; /* impossible value */
    }
}
