/*
 *  Copyright (C) 1994-2000  Kevin P. Lawton
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>


#define BX_DBG_A20_REPORT(val)

#include "config.h"
#include "plex86.h"
#include "user.h"
#include "plugin.h"

#define uint8   Bit8u
#define uint16  Bit16u
#define uint32  Bit32u

extern "C" int bx_plex86_io(event_t event, int data, int op_size, int count, void *loc);
void bx_printf(char *fmt, ...);
void bx_panic(char *fmt, ...);

typedef struct {
  Boolean floppy;
  Boolean keyboard;
  Boolean video;
  Boolean disk;
  Boolean pit;
  Boolean pic;
  Boolean bios;
  Boolean cmos;
  Boolean a20;
  Boolean interrupts;
  Boolean exceptions;
  Boolean unsupported;
  Boolean temp;
  Boolean reset;
  Boolean debugger;
  Boolean mouse;
  Boolean io;
  Boolean xms;
  Boolean v8086;
  Boolean paging;
  Boolean creg;
  Boolean dreg;
  Boolean dma;
  Boolean unsupported_io;
  Boolean serial;
  Boolean cdrom;
#ifdef MAGIC_BREAKPOINT
  Boolean magic_break_enabled;
#endif /* MAGIC_BREAKPOINT */
  void* record_io;
  } bx_debug_t;

extern bx_debug_t bx_dbg;



//#include "debug/debug.h"
#include "state_file.h"
//#  include "cpu/cpu.h"
//#  include "disasm/disasm.h"
//#  include "dynamic/dynamic.h"
//#include "memory/memory.h"

enum PCS_OP { PCS_CLEAR, PCS_SET, PCS_TOGGLE };

#include "pc_system.h"
#include "gui/gui.h"
extern bx_gui_c bx_gui;
#include "iodev/iodev.h"
// #  include "external_interface.h"
//#include "instrument.h"

typedef struct {
  char path[512];
  unsigned type;
  unsigned initial_status;
  } bx_floppy_options;

typedef struct {
  Boolean present;
  char path[512];
  unsigned int cylinders;
  unsigned int heads;
  unsigned int spt;
  } bx_disk_options;
 
struct bx_cdrom_options
{
  Boolean present;
  char dev[512];
  Boolean inserted;
};
 
typedef struct {
  char *path;
  unsigned long address;
  } bx_rom_options;
 
typedef struct {
  char *path;
  } bx_vgarom_options;
 
typedef struct {
  size_t megs;
  } bx_mem_options;
 
typedef struct {
  char      *path;
  Boolean   cmosImage;
  unsigned int time0;
  } bx_cmos_options;
 
typedef struct {
  int       valid;
  unsigned  ioaddr;
  unsigned  irq;
  unsigned char macaddr[6];
  char      *ethmod;
  char      *ethdev;
  } bx_ne2k_options;

typedef struct {
  char *midifile, *wavefile, *logfile;
  unsigned int midimode, wavemode, loglevel;
  Bit32u dmatimer;
  } bx_sb16_options;

typedef struct {
  bx_floppy_options floppya;
  bx_floppy_options floppyb;
  bx_disk_options   diskc;
  bx_disk_options   diskd;
  bx_cdrom_options  cdromd;
  bx_sb16_options   sb16;
  char              bootdrive[2];
  unsigned long     vga_update_interval;
  unsigned long     keyboard_serial_delay;
  unsigned long     floppy_command_delay;
  unsigned long     ips;
  Boolean           mouse_enabled;
  Boolean           private_colormap;
  Boolean           i440FXSupport;
  bx_cmos_options   cmos;
  bx_ne2k_options   ne2k;
  Boolean           newHardDriveSupport;
  } bx_options_t;

#define bx_ptr_t void *

extern bx_options_t bx_options;
extern bx_devices_c bx_devices;
extern plugin_t *bx_plugin;

#define BX_SET_ENABLE_A20(enabled) plugin_set_A20E(enabled)
#define BX_GET_ENABLE_A20()        plugin_get_A20E()

#define BX_SET_INTR(b) (plugin_set_intr(b))

#define BX_INSTR_INP(addr, io_len)
#define BX_INSTR_OUTP(addr, len)
#define BX_DBG_IAC_REPORT(vector, irq)
#define BX_DBG_IO_REPORT(addr, size, op, val)
#define BX_TICK1()

#define GUI_WINDOW_TITLE "http://www.plex86.org"
#define BX_CPU_LEVEL 5

#define BX_EJECTED   10
#define BX_INSERTED  11
 
#define BX_RESET_SOFTWARE 10
#define BX_RESET_HARDWARE 11

#define BX_FLOPPY_NONE   10 // floppy not present
#define BX_FLOPPY_1_2    11 // 1.2M  5.25"
#define BX_FLOPPY_1_44   12 // 1.44M 3.5"
#define BX_FLOPPY_2_88   13 // 2.88M 3.5"
#define BX_FLOPPY_720K   14 // 720K  3.5"
