/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  replay.c: replay IO events from a previous execution.  This
 *     is useful for intializing devices without needing the BIOS.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

#include "plex86.h"
#include "user.h"
#include "plugin.h"


plugin_t *bios_plugin;


  int
plugin_init(plugin_t *plugin, int argc, char *argv[])
{
  char *filename_p;
  FILE *fp;
  unsigned line;

#define FILE_PARAM    "file="

  bios_plugin = plugin;
  if (argc != 1)
    goto usage;

  // Get the file= parameter
  if ( !argv[0] || strncmp(argv[0], FILE_PARAM, strlen(FILE_PARAM)) )
    goto usage;
  filename_p = &argv[0][strlen(FILE_PARAM)];

  fp = fopen(filename_p, "r");
  if (!fp) {
    fprintf(stderr, "could not open IO log file '%s'.\n", filename_p);
    return 1;
    }
  fprintf(stderr, "replaying IO events from log file '%s'.\n", filename_p);
  line = 1;
  while (!feof(fp)) {
    unsigned len, rw, port, data;
    int ret;
    ret = fscanf(fp, "%u %u %x %x\n", &len, &rw, &port, &data);
    if (ret != 4) {
      fprintf(stderr, "Error reading IO log file '%s'.\n", filename_p);
      fclose(fp);
      return 1;
      }
    if (rw==0) {
      unsigned temp;
      temp = 0;
      plugin_emulate_inport(port, len, 1, &temp);
      if (temp!=data) {
        fprintf(stderr, "IO replay read value (0x%x) not expected, line %u.\n",
                temp, line);
        fclose(fp);
        return 1;
        }
      }
    else if (rw==1) {
      plugin_emulate_outport(port, len, 1, &data);
      }
    else {
      fprintf(stderr, "Error reading IO log file '%s'.\n", filename_p);
      fclose(fp);
      return 1;
      }
    line++;
    }
  fclose(fp);
  return 0;

usage:
  fprintf(stderr, "usage: replay_io.so file=path\n");
  return 1;
}


void
plugin_fini(void)
{
    return;
}
