.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "SHOW" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
SHOW \- show the value of a run-time parameter
.SH SYNOPSIS
.sp
.nf
SHOW \fIname\fR
  
.sp
.fi
.sp
.nf
SHOW ALL
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a run-time parameter. See
SET [\fBset\fR(l)]
for a list.
.TP
\fBALL\fR
Show all current session parameters.
.PP
.SH "DESCRIPTION"
.PP
\fBSHOW\fR will display the current setting of a
run-time parameter. These variables can be set using the
\fBSET\fR statement, by editing the
\fIpostgresql.conf\fR, through the
\fBPGOPTIONS\fR environmental variable, or through a
command-line flag when starting the
\fBpostmaster\fR.
.PP
Even with autocommit set to off, \fBSHOW\fR
does not start a new transaction block. See the
autocommit section of the \fIAdministrator's
Guide\fR for details.
.SH "DIAGNOSTICS"
.PP
.TP
\fBERROR: Option '\fIname\fB'\fR
Message returned if \fIname\fR does
not stand for an existing parameter.
.PP
.SH "EXAMPLES"
.PP
Show the current DateStyle setting:
.sp
.nf
SHOW DateStyle;
               DateStyle
---------------------------------------
 ISO with US (NonEuropean) conventions
(1 row)
.sp
.fi
.PP
Show the current genetic optimizer (geqo) setting:
.sp
.nf
SHOW GEQO;
 geqo
------
 on
(1 row)
.sp
.fi
.PP
Show all settings:
.sp
.nf
SHOW ALL;
             name              |                setting
-------------------------------+---------------------------------------
 australian_timezones          | off
 authentication_timeout        | 60
 checkpoint_segments           | 3
    .
    .
    .
 wal_debug                     | 0
 wal_sync_method               | fdatasync
(94 rows)
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBSHOW\fR command is a
PostgreSQL extension.
.SH "SEE ALSO"
.PP
The function \fBcurrent_setting\fR produces equivalent
output. See \fIMiscellaneous Functions\fR in the
\fIPostgreSQL User's Guide\fR.
