#!/usr/local/bin/perl -w
use strict;
require 5.002;
# ************************************************************ #
# NAME: psmulti-default
# PURPOSE: Basic perl routine for generating psmulti documents.
# NOTES: 
# SCCS: @(#)psmulti-default.pl	2.2 4/7/92
# HISTORY:
#       murray - Mar 26, 1992: Created.
# ************************************************************ #

#
# port to perl5 by Denis N. Antonioli <antonio@ifi.unizh.ch>
#  1.0    27 4 1997
#  1.0.1  28 5 1998
#

# ##################################################################### #
# (C) 1992 D Murray Laing, D.M.Laing@uk.ac.edinburgh
#          c/o Department of Chemical Engineering,
#              University of Edinburgh,
#              Edinburgh,
#              Scotland
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License version 2 as
#    published by the Free Software Foundation.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# ###################################################################### #

# ============================================================ #
#             Load in Required Utilities
# ============================================================ #

require 'pspp-util.pl';
require 'file-util.pl';
require 'dsc-util.pl';

# ============================================================ #
#              Variables
# ============================================================ #
my ($pbbox, $ibbox, %DSC);
# ============================================================ #
#              Set Up Undefined Defaults
# ============================================================ #

my @GlobalExport = ('Rows', 'Columns', 'RowMajor', 'FPageBBox',
					'TtoB', 'LtoR'
					);

my @DocExport = ( 'ImageBBox', 'EPSDoc', 'NoDecor',
				 'MarginX', 'MarginY',
				 'Rotate', 'ScaleX', 'ScaleY', 'JustX', 'JustY'
				 );

# Set Up Global Defaults if Not Already Defined #

$::Global{'Style'}='shadow' unless defined $::Global{'Style'};

if ( ! defined $::FileSettings{'Default'}{'Rotate'} ) {
	if ( $#::FileList == 0 && defined $::FileSettings{$::FileList[0]}{'Rotate'} ) {
		$::FileSettings{'Default'}{'Rotate'}=$::FileSettings{$::FileList[0]}{'Rotate'};
	}
}

if ( ! ( defined $::Global{'Rows'} && defined $::Global{'Columns'} && defined $::FileSettings{'Default'}{'Rotate'})) {
	require 'page-configure.pl';

    $::Global{'Pages'} = 2 unless defined $::Global{'Pages'};

    # Get Full Page BBox #

if ( defined $::Global{'FPageBBox'} ) {
	$pbbox=$::Global{'FPageBBox'};
} else {
	$pbbox='null';
}

    # Get Default Image BBox #

if ( defined $::FileSettings{'Default'}{'ImageBBox'} ) {
	$ibbox=$::FileSettings{'Default'}{'ImageBBox'};
} elsif ( defined $::FileSettings{$::FileList[0]}{'ImageBBox'} ) {
	$ibbox=$::FileSettings{$::FileList[0]}{'ImageBBox'};
} else {
	$ibbox='null';
}

if ( $ibbox eq 'dsc' ) {
	open(INPUT, $::FileList[0]);
	&read_dsc_param(\*INPUT, \%DSC);
	
	if ( defined $DSC{'BoundingBox'} ) {
		$ibbox = $DSC{'BoundingBox'};
	} else {
		$ibbox = 'null';
	}

	close(INPUT);
	%DSC=();
}

    # Now use configure to calculate default rotation #
$::FileSettings{'Default'}{'Rotate'} =  &configure($::Global{'Pages'}, $pbbox, $ibbox, $::FileSettings{'Default'}{'Rotate'});

&info("Using $::Global{'Columns'}x$::Global{'Rows'} geometry and $::FileSettings{'Default'}{'Rotate'} degrees rotation");
  }

# ============================================================ #
#            Generate the Postscript
# ============================================================ #

# -------------------------------------------------- #
#               Multi Prolog
# -------------------------------------------------- #

print "%!PS-Adobe\n%%Creator: psmulti\n%%Pages: (atend)\n";

if ( defined $::Global{'FPageBBox'} && $::Global{'FPageBBox'} ne '/Default' ) {
	print "%%BoundingBox: ", $::Global{'FPageBBox'};
}

print "%%EndComments\n%%BeginPrologue\n";

&pspp_cat('format-raw.ps', {'StyleFile' => "border-$::Global{'Style'}.ps"})
    || &error($@);

# -------------------------------------------------- #
#                   Multi Setup
# -------------------------------------------------- #

print "%%BeginSetup\n/StartParam\n";

foreach (@GlobalExport) {
	if (defined $::Global{$_}) {
	    print "$::Global{$_} /$_\n";
    } else {
	    print "/Default /$_\n";
    }
}

print "/EndParam\nBeginMulti\n%%EndSetup\n";

# -------------------------------------------------- #
#            Document Processing
# -------------------------------------------------- #

my ($LperP, $LPages, $PPages) = ($::Global{'Columns'}*$::Global{'Rows'}, 0, 0);

my $File;
foreach $File (@::FileList) {
	my ($dsc_ok, @order, $FoundFirstPage);
    # -------------------------------------------------- #
    #    Open the File for Random Access
    # -------------------------------------------------- #

	&error("Unable to open $File") unless open(INPUT, $File);

	&info("Processing document: $File");

    # -------------------------------------------------- #
    #  Parse the Document Structure
    # -------------------------------------------------- #

    %DSC=();
    $dsc_ok=1;

    &info('Document Non-conformant') unless $dsc_ok;

    # -------------------------------------------------- #
    # Set Up Necessary Defaults that are still Undefined
    # -------------------------------------------------- #

	if ( ! defined $::FileSettings{$File}{'ImageBBox'} && defined $::FileSettings{'Default'}{'ImageBBox'} ) {
		$::FileSettings{$File}{'ImageBBox'} = $::FileSettings{'Default'}{'ImageBBox'};
	}

    if ( defined $::FileSettings{$File}{'ImageBBox'} && $::FileSettings{$File}{'ImageBBox'} eq 'dsc' ) {
	    $dsc_ok = &read_dsc_param(\*INPUT, \%DSC);
        if ( defined $DSC{'BoundingBox'} ) {
			$::FileSettings{$File}{'ImageBBox'} = $DSC{'BoundingBox'};
		}
	}

	if ( defined $::FileSettings{$File}{'ImageBBox'} ) {
		&info("Using Bounding Box: $::FileSettings{$File}{'ImageBBox'}");
	} else {
		&info('No Bounding Box Defined');
	}

	my($reverse, $select, $select_by, $do_select) = (0, undef, 'ordinal', 0);
    if( defined $::FileSettings{$File}{'ReversePages'} ) {
		$reverse= $::FileSettings{$File}{'ReversePages'};
	} elsif( defined $::FileSettings{'Default'}{'ReversePages'} ) {
		$reverse= $::FileSettings{'Default'}{'ReversePages'};
	}


    if( defined $::FileSettings{$File}{'SelectPages'} ) {
		$select=$::FileSettings{$File}{'SelectPages'};
	} elsif ( defined $::FileSettings{'Default'}{'SelectPages'} ) {
		$select=$::FileSettings{'Default'}{'SelectPages'};
	}

    if( defined $::FileSettings{$File}{'SelectBy'} ) {
		$select_by = $::FileSettings{$File}{'SelectBy'};
	} elsif( defined $::FileSettings{'Default'}{'SelectBy'} )  {
		$select_by = $::FileSettings{'Default'}{'SelectBy'};
	}

    # See whether it is necessary and possible to select pages #
	if ( $dsc_ok && ($reverse || defined $select) ) {
		if ( &read_dsc(\*INPUT, \%DSC) ) {
			$do_select=1;
			# Make sure we have a valid page selection #
			@order= &page_order(\%DSC, $select, $select_by);
			@order = reverse(@order) if $reverse;

			if ( $#order < 0 ) {
				&warning('Null page selection specified skipping document');
				next;
			} else {
				&info('Pages selected: ' . join(',' , @order) );
			}
		} else {
			&warning('Document non-conformant, cannot do page selection');
			$do_select=0;
		}
	}
    # -------------------------------------------------- #
    #     Setup the Document Specific Parameters
    # -------------------------------------------------- #

    print "/StartParam\n";

    foreach (@DocExport) {
		my $value = '';
		$value = $::FileSettings{$File}{$_} if defined $::FileSettings{$File}{$_};
        if ( $value =~ /^\s*$/o ) {
			$value = $::FileSettings{'Default'}{$_} if defined $::FileSettings{'Default'}{$_};
			$value = '/Default' if $value =~ /^\s*$/o;
		}
        print "$value /$_\n"; 
	}
    print "/EndParam\nBeginDocument\n";


    # ---------------------------------------- #
    #        Document Prolog & Setup
    # ---------------------------------------- #
    print "%*%%BeginDocument: $File\n";

	if ( $do_select) {
          
        # Print the Document Prolog and Setup #

        print "%*%%BeginProlog\n";
        &cat_region(\*INPUT, \*OUTPUT, $DSC{'BeginProlog'}, $DSC{'EndProlog'});
        print "%*%%EndProlog\n";

		if ( defined $DSC{'BeginSetup'} ) {
			print "%*%%BeginSetup\n";
			&cat_region(\*INPUT, \*OUTPUT, $DSC{'BeginSetup'}, $DSC{'EndSetup'});
			print "%*%%EndSetup\n";
		}

		foreach(@order) {
			$LPages++;
			if ( $LPages % $LperP == 1 || $LperP == 1 ) {
				$PPages++;
				print "%%Page: ? $PPages\n";
			}

			print "%*%%Page: ? $_\n";
			&cat_region(\*INPUT, \*OUTPUT, $DSC{"StartPage:$_"}, $DSC{"EndPage:$_"});
		}

# Finally the Document Trailer

		print "%*%%Trailer\n";
		&cat_region(\*INPUT, \*OUTPUT, $DSC{'Trailer'}, $DSC{'EndTrailer'});
	} else {
		seek(INPUT,0,0);
		while ( <INPUT> ) {
			if ( /^%%Page:/o ) {
				$LPages++;
				if ( $LPages % $LperP == 1 || $LperP == 1 ) {
					$PPages++;
					print "%%Page: ? $PPages\n";
				}
				print "%*$_";
			} elsif ( /^%%/o ) {
				print "%*$_";
			} else {
				print $_;
			}
		}
	}

    print "%*%%EndDocument\nEndDocument\n";
    &info("Completed Document: $File");
    &info("Page Count Now - $LPages Logical, $PPages Physical");

    close(INPUT);
}

# -------------------------------------------------- #
#                  Multi Trailer
# -------------------------------------------------- #

print "%%Trailer\nEndMulti\n%%Pages: $PPages\n%%EOF\n";

# ============================================================ #
# END of Package psmulti-default.pl
# ============================================================ #
1;
