/***************************************************************************
                          rlayerdialog.cpp  -  description
                             -------------------
    begin                : Wed Feb 9 2000
    copyright            : (C) 2000 by Gerald Pichler
    email                : geripi@sbox.tu-graz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rlayerdialog.h"

#include "rgraphic.h"

RLayerDialog::RLayerDialog(QWidget *_parent, const char *_name, RLayer *_lay)
: QDialog(_parent,_name,true){
  this->resize(410,150);
  this->setMinimumSize(0,0);
  QLineEdit_Name= new QLineEdit(this,"Name");
  QLineEdit_Name->setGeometry(30,40,100,20);
  QLineEdit_Name->setMinimumSize(0,0);
  QLineEdit_Name->setFocus();
  QLineEdit_Name->setText(_lay->getName());
  QLineEdit_Name->selectAll();

  cb_Color= new RComboBox(false, this,"Color");
  cb_Color->fillInColors();
  cb_Color->setCurrentItem(RGraphic::colorToNumber(_lay->getColor()));
  cb_Color->setGeometry(160,40,42,20);
  cb_Color->setMinimumSize(0,0);

  cb_Width= new RComboBox(false, this,"Width");
  cb_Width->fillInWidths();
  cb_Width->setCurrentItem(_lay->getWidth());
  cb_Width->setGeometry(240,40,42,20);
  cb_Width->setMinimumSize(0,0);

  cb_Style= new RComboBox(false, this,"Style");
  cb_Style->fillInStyles();
  cb_Style->setCurrentItem(styleToNumber(_lay->getStyle()));
  cb_Style->setGeometry(320,40,42,20);
  cb_Style->setMinimumSize(0,0);

  QPushButton_Ok= new QPushButton(this,"b_Ok");
  QPushButton_Ok->setGeometry(70,90,100,30);
  QPushButton_Ok->setMinimumSize(0,0);
	QPushButton_Ok->setText(tr("Ok"));
  connect(QPushButton_Ok, SIGNAL(clicked()), SLOT(accept()));

  QPushButton_Cancel= new QPushButton(this,"b_Cancel");
  QPushButton_Cancel->setGeometry(240,90,100,30);
  QPushButton_Cancel->setMinimumSize(0,0);
	QPushButton_Cancel->setText(tr("Cancel"));
  connect(QPushButton_Cancel, SIGNAL(clicked()), SLOT(reject()));

  QLabel_1= new QLabel(this,"NoName");
  QLabel_1->setGeometry(30,20,100,20);
  QLabel_1->setMinimumSize(0,0);
  QLabel_1->setText(tr("Name:"));

  QLabel_2= new QLabel(this,"NoName");
  QLabel_2->setGeometry(160,20,60,20);
  QLabel_2->setMinimumSize(0,0);
  QLabel_2->setText(tr("Color:"));

  QLabel_3= new QLabel(this,"NoName");
  QLabel_3->setGeometry(240,20,60,20);
  QLabel_3->setMinimumSize(0,0);
  QLabel_3->setText(tr("Width:"));

  QLabel_4= new QLabel(this,"NoName");
  QLabel_4->setGeometry(320,20,60,20);
  QLabel_4->setMinimumSize(0,0);
  QLabel_4->setText(tr("Style:"));

}

RLayerDialog::~RLayerDialog(){
}

// Get the entered name:
//
QString
RLayerDialog::getName(){
	return QLineEdit_Name->text();
}

// Get the chosen color or -1 if no color was chosen:
//
QColor
RLayerDialog::getColor(){
  if(cb_Color) {
    return RGraphic::numberToColor(cb_Color->currentItem());
  }

  return QColor();
}

// Get the chosen width or -1 if no width was chosen:
//
int
RLayerDialog::getWidth()
{
  if(cb_Width) {
    return cb_Width->currentItem();
  }

  return -1;
}

// Get the chosen style or -1 if no style was chosen:
//
Qt::PenStyle
RLayerDialog::getStyle()
{
  return numberToStyle(cb_Style->currentItem());

}

// Gets the style from a style number
//
Qt::PenStyle
RLayerDialog::numberToStyle(int _num)
{
  switch(_num) {
    default:
    case 0: return Qt::SolidLine;      break;
    case 1: return Qt::DashLine;       break;
    case 2: return Qt::DotLine;        break;
    case 3: return Qt::DashDotLine;    break;
    case 4: return Qt::DashDotDotLine; break;
  }

  return Qt::SolidLine;
}


// Gets the style number from a style
//
int
RLayerDialog::styleToNumber(Qt::PenStyle _style)
{
  switch(_style) {
    default:
    case Qt::SolidLine: return 0;      break;
    case Qt::DashLine: return 1;       break;
    case Qt::DotLine: return 2;        break;
    case Qt::DashDotLine: return 3;    break;
    case Qt::DashDotDotLine: return 4; break;
  }

  return 0;
}
