#ifndef ADDRESS_H
#define ADDRESS_H

#include <string>
#include <stdint.h>

using namespace std;

class Address
{
 public:
  Address();
  Address(std::string ip);
  Address(std::string ip, const uint16_t port);
  Address(const uint32_t ip);
  Address(const uint32_t ip, const uint16_t port);

  std::string        strIP();
  const uint16_t     port();
  const uint32_t     longIP();
  std::string        toString();
  void               setPort(const uint16_t port);
  void               setPort(std::string port);
  void               setIP(std::string ip);
  bool               isPrivate();

  std::string        strPort();

 private:
  std::string        _ip;
  uint16_t           _uiport;
};

#endif
