#ifndef CONNECTIONS_H
#define CONNECTIONS_H

#include "qobject.h"
#include <qiconset.h>

#include "Statistic.h"
#include "Address.h"

class QtellaSub;
class QListViewItem;
class QWidget;
class QTimer;
class QDateTime;
class QSocket;
class Servent;
class QueryHitEntry;
class SearchWidget;
class Search;
class Message;

#include <vector>
#include <string>
#include <ctime>

using namespace std;

class Connections : QObject
{
  Q_OBJECT

 public:
  Connections(QtellaSub *parent = 0);
  ~Connections();

  void               start();
  void               search(std::string query, SearchWidget *sw);
  void               checkServants();
  void               checkMessages(Servent* servant);
  void               disconnect();
  std::string        createID();
  static std::string toHex(std::string data);
  void               addServant(Address address, QSocket* socket = NULL);
  void               sendAll(std::string data);
  
  std::vector<Search*>     _search;
  std::vector<Servent*>    _servants;

  std::string         _id;
  QtellaSub*          _parent;
  Statistic           _statistic;
  Address             _address;

 protected:
  int                 _max_servants;
  int                 _max_hosts;
  QTimer*             _statistic_timer;
  QDateTime*          _uptime;
  QTimer*             _timer;
  time_t              _last_query_time;

 public slots:
  void     check();
  void     slotRemoveHost();
  void     slotAddHost();
  void     slotMaxServents(int value);
  void     slotListClear();
  void     slotListRemove();
  void     slotListConnect();
  void     slotUpdateStatistic();
};

#endif
