#ifndef DOWNLOADMANAGER_H
#define DOWNLOADMANAGER_H

#include <qobject.h>

#include <vector>
#include <string>

class QTimer;
class QListViewItem;
class QueryHitEntry;
class QtellaSub;
class QSocket;
class Download;

using namespace std;

class DownloadManager : public QObject
{
 Q_OBJECT

 public:
  DownloadManager(QtellaSub *parent);

  void              addDownload(QueryHitEntry &qhe, QListViewItem *item);
  int               numberOfDownloads();
  void              updatePush(std::string data, QSocket* socket);

  QtellaSub*                  _parent;
  std::vector<Download*>      _downloads;

 private:
  QTimer*                     _update_timer;

 private slots:
  void              slotUpdate();
  void              slotAbortDownload();
  void              slotResumeDownload();
  void              slotRemoveDownload();
  void              slotClearInactive();
};

#endif
