#ifndef HOST_H
#define HOST_H

#include <string>
#include "Address.h"

using namespace std;

/**
 * @short This class stores informations about an host.
 * This class stores informations about another host like
 * the number of shared files, the shared size and the
 * host's address.
 */
class Host
{
 public:
  /**
   * @short Creates a new object.
   * This constructor creates a new object with the given address,
   * number of files and shared size.
   */
  Host(const Address address, long files=0, long kbytes=0);

  ~Host();

  /**
   * @short Returns the number of shared files.
   */
  const long   numberOfSharedFiles();

  /**
   * @short Returns the shared size.
   */
  const long   sharedSize();

  Address      address;
 private:
  long         files;
  long         kbytes;
};

#endif
