#ifndef INCOMINGCONNECT_H
#define INCOMINGCONNECT_H

#include "qserversocket.h"
#include <string>

class QtellaSub;
class QTimer;
class QSocket;

using namespace std;

class IncomingConnect : public QServerSocket
{
 Q_OBJECT

 public:
  IncomingConnect(Q_UINT16 port, int backlog = 0, QtellaSub *parent = 0);
  ~IncomingConnect();

 private slots:
  void         slotReadyRead();
  void         slotTimeout();

 private:
  virtual void newConnection(int socket);
  QtellaSub*   _parent;
  QTimer*      _timeout;
  QSocket*     _socket;
  std::string  _rec;
};

#endif
