#ifndef MESSAGE_H
#define MESSAGE_H

#include <string>
#include <stdint.h>

class Ping;
class Pong;
class Query;
class QueryHit;
class Push;

using namespace std;

class Message
{
 public:
  Message(std::string& data, const uint32_t size);
  Message();
  ~Message();

  const uint8_t       cmd();
  const uint8_t       ttl();
  const uint8_t       hops();
  const uint32_t      payload();
  const uint32_t      size();
  std::string         id();
  std::string         data();
  bool                isValid();

  static std::string  uint_str(uint32_t value);
  static std::string  uint_str(uint16_t value);
  static std::string  uint_str(uint8_t value);

  void          dec_ttl();
  void          inc_hops();

  Ping*         getPing();
  Pong*         getPong();
  Query*        getQuery();
  QueryHit*     getQueryHit();
  Push*         getPush();

 private:
  std::string   _data;
  std::string   _payload_data;
  std::string   _id;
  uint8_t       _ttl;
  uint8_t       _hops;
  uint8_t       _cmd;
  uint32_t      _payload;
};

#endif
