#ifndef PONGCACHE_H
#define PONGCACHE_H

#include <ctime>
#include <stdint.h>
#include <list>
#include <map>

#include <qobject.h>

#include "Pong.h"

class Servent;
class QTimer;

class PongData
{
 public:
  PongData(Pong pong, unsigned int number) : _pong(pong), _servant_number(number), _time(time(NULL)) { };

  Pong              _pong;
  unsigned int      _servant_number;
  time_t            _time;
};


class HostData
{
 public:
  HostData(std::string id, unsigned int number) : _id(id), _servant_number(number), _time(time(NULL)) {};
  
  std::string       _id;
  unsigned int      _servant_number;
  time_t            _time;
};


class PongCache : public QObject
{
 Q_OBJECT

public:
  static PongCache*      getInstance();
  ~PongCache();

  uint32_t               getSharedSize();
  uint32_t               getHosts(unsigned int servant_number = 0);
  uint32_t               getNumberOfFiles();

  void                   removePong(unsigned int servant_number);
  void                   addPong(Pong pong, unsigned int servant_number);
  void                   getPong(std::list<Pong>& pong_list, int n = 10);
  void                   clear();
  void                   addHost(std::string id, unsigned hops, unsigned servant_number);

protected:
  PongCache();

private slots:
  void                   expireTimeout();

private:
  static PongCache*      _this; 
  QTimer*                _expire;
  uint32_t               _size;
  uint32_t               _files;

  std::list<PongData>    _cache[7];
  std::list<HostData>    _hosts[7];

  std::map<int, int>     _nhosts;
};

#endif
