#ifndef QTELLASUB_H
#define QTELLASUB_H

#include <string>
#include <vector>
#include <list>

class QMenuBar;
class Connections;
class SharedFile;
class UploadManager;
class DownloadManager;
class IncomingConnect;
class QPopupMenu;

class QTimer;
class ExecThread;

#include "qthread.h"
#include <qapplication.h>

#include "Qtella.h"

#ifdef KDE
#include "kmenubar.h"
#include "kpopupmenu.h"
#endif

using namespace std;

class QtellaSub : public Qtella
{ 
    Q_OBJECT

 public:
    QtellaSub( QApplication* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~QtellaSub();

    #ifdef KDE
    KMenuBar             *menu;
    #endif

    #ifdef QT
    QMenuBar             *menu;
    #endif

    Connections*         connections;
    QTimer*              timer_connection;
    
    std::vector< pair<std::string, std::string> > _applications;
    std::vector<SharedFile*>  vSharedFiles;
    
    unsigned long        number_shared_files;
    double               shared_size;
    std::string          _types_images;
    std::string          _types_videos;
    std::string          _types_music;

    static void          sighandler(int);
    void                 checkDirectories(std::string directory, std::vector<SharedFile*> *old);
    void                 removeFiles(const int size);
    void                 launchFile(std::string filename);

    UploadManager*       upload_manager;
    DownloadManager*     download_manager;
    IncomingConnect*     _incoming_connect;

    QPopupMenu*          _context_download;
    QPopupMenu*          _context_search;
    QPopupMenu*          _context_upload;
    QPopupMenu*          _context_shared;

 public slots:

    virtual void slotSharedFilesLaunch(QListViewItem* item);
    virtual void slotSharedFilesLaunch();
    virtual void slotAddApplication();
    virtual void slotRemoveApplication();
    void slotConnect();
    void slotDisconnect();
    void check_connections();
    void slotInfo();

    virtual void slotDownloadDoubleClicked(QListViewItem* item);
    virtual void slotDownloadShowContext(QListViewItem*, const QPoint&, int);
    virtual void slotLaunchSelectedDownloadItem();
    virtual void slotShowSearchContext(QListViewItem*, const QPoint&, int);
    virtual void slotShowUploadContext(QListViewItem*, const QPoint&, int);
    virtual void slotShowSharedContext(QListViewItem*, const QPoint&, int);
    virtual void slotMoveDownloads();
    virtual void slotSharedProperties();

    virtual void slotRefreshSharedList();
    virtual void slotSearch();
    virtual void slotAddDirectory();
    virtual void slotRemoveDirectory();
    virtual void slotApplyConfig();
    virtual void slotStopSearch();
    virtual void slotCurrentChanged(QWidget*);

    virtual void slotDownloadAll();
    virtual void slotSearchDoubleClicked(QListViewItem*);

    virtual void slotAddAutoConnect();
    virtual void slotRemoveAutoConnect();
    virtual void slotAddHost();
    virtual void slotAbortUpload();
    virtual void slotRemoveUpload();
    virtual void slotDeleteSharedFile();
    virtual void slotClearInactiveUploads();
    virtual void slotReadFile();

 private:
    void                     downloadItem(QListViewItem *item);
    void                     readConfiguration();
    void                     readHostList();

    std::string              _binary;
    std::string              conffile;
    int                      search_tabs;

    QMutex                   mutex_shared_files;
};

#endif // QTELLASUB_H
