#ifndef QUERYHIT_H
#define QUERYHIT_H

#include "QueryResult.h"
#include "Address.h"

#include <vector>
#include <stdint.h>

using namespace std;

class QueryHit
{
 public:
  QueryHit(const uint8_t ttl, const uint8_t hops, std::string id, std::string data);

  QueryHit(std::string header_id, const uint8_t ttl, const uint8_t hops, Address& address, const uint32_t speed,
	   std::string result_id, vector<QueryResult>& vQueryResult);

  uint8_t                   _ttl;
  uint8_t                   _hops;
  uint8_t                   _hits;
  uint32_t                  _speed;
  std::string               _id;
  std::string               _id_result;
  std::string               _trailer;
  std::string               _data;
  std::vector<QueryResult>  _results;
  Address                   _address;

 private:
  void                      toString();
};

#endif
