#ifndef QUERYHITENTRY_H
#define QUERYHITENTRY_H

class QListViewItem;
#include <string>
#include "Address.h"

using namespace std;

class QueryHitEntry
{
 public:
  QueryHitEntry();
  QueryHitEntry(std::string& filename, const uint32_t size, const uint32_t index, const uint32_t speed, int status, Address& addr, std::string& id, QListViewItem *item);
  ~QueryHitEntry();

  bool              firewalled();
  
  //! Filename of QueryHit.
  std::string       filename;

  //! Size of file.
  uint32_t          size;

  //! Index of file.
  uint32_t          index;

  //! Download speed of host.
  uint32_t          speed;

  //! Address of host.
  Address           addr;

  //! Status of host
  int               status;

  //! Gnutella ID of host.
  std::string       id;

  //! Pointer to item in QListView.
  QListViewItem*    item;

  static const int  Busy;
  static const int  Ready;
  static const int  Firewalled;
  static const int  Unknown;
};

#endif
