#ifndef STATISTIC_H
#define STATISTIC_H

#include <string>
#include <strstream>

using namespace std;

class Statistic
{
 public:
  Statistic();

  std::string   str(const double value, const int prec = 0);

  const unsigned long    in_all_n();
  const double           in_all_b();
  const unsigned long    out_all_n();
  const double           out_all_b();
  const unsigned long    hits_all_n();

  unsigned long    in_ping_n;
  unsigned long    in_pong_n;
  unsigned long    in_query_n;
  unsigned long    in_hit_n;
  unsigned long    in_push_n;

  double    in_ping_b;
  double    in_pong_b;
  double    in_query_b;
  double    in_hit_b;
  double    in_push_b;

  unsigned long    out_ping_n;
  unsigned long    out_pong_n;
  unsigned long    out_query_n;
  unsigned long    out_hit_n;
  unsigned long    out_push_n;

  double    out_ping_b;
  double    out_pong_b;
  double    out_query_b;
  double    out_hit_b;
  double    out_push_b;

  unsigned long    hits_qtel_n;
  unsigned long    hits_lime_n;
  unsigned long    hits_bear_n;
  unsigned long    hits_othe_n;

  double  loads_usucc;
  double  loads_uabor;
  double  loads_usize;
  double  loads_dsucc;
  double  loads_dabor;
  double  loads_dsize;

  double shared_files;
  double shared_size;
};

#endif
