#ifndef UPLOAD_H
#define UPLOAD_H

#include "qobject.h"
#include "qfile.h"
#include "qdatetime.h"
#include <string>

#include "Push.h"

class QSocket;
class UploadManager;
class QListViewItem;
class QTimer;

using namespace std;

class Upload : public QObject
{
  Q_OBJECT

 public:
  Upload(UploadManager *parent, std::string data, QSocket *socket);
  Upload(UploadManager *parent, Push push);

  ~Upload();

  void initUpload();
  int  getState();
  void setState(int state);
  void abortUpload();

  enum {  
    Busy,
    Start,
    Connected,
    NotFound,
    Finished,
    Error,
    Abort,
    Closed,
    Connecting
  };

  QListViewItem*    item;
  QTimer*           _timer;
  QFile             _file;
  QTime             _time_start;
  Push              _push_data;

 private:
  unsigned long     _written;
  unsigned long     _towrite;
  QSocket*          _socket;
  std::string       client;
  unsigned long     index;
  unsigned long     range_start;
  unsigned long     range_end;
  std::string       filename;
  int               _state;
  bool              _push;
  std::string       _data;

  UploadManager*    _parent;

  static const std::string statestr[];

 private slots:
  void              slotClosed();
  void              slotTimer();
  void              slotConnected();
  void              slotReadyRead();
};

#endif
