#include "Address.h"

#include <qhostaddress.h>
#include <qdns.h>
#include <qvaluelist.h>

#include <strstream>

Address::Address()
{
//   char hostname[50];
//   gethostname(hostname, 50);
//   char domainname[50];
//   getdomainname(domainname, 50);

//   std::strstream str;
//   str << hostname << "." << domainname << std::ends;

//   QDns                     dns(str.str());
  QValueList<QHostAddress> list;

//   list = dns.addresses();

  if(list.isEmpty())
    _ip = "0.0.0.0";
  else
    _ip = list.first().toString();

  _uiport = 0;
//   str.freeze(false);
}

Address::Address(const std::string ip)
{
  std::string::size_type Idx = ip.find(":");
  if(Idx == std::string::npos)
    {
      _ip = ip;
      _uiport = 0;
    }
  else
    {
      _ip = ip.substr(0, Idx);
      _uiport = atol((ip.substr(Idx+1)).c_str());
    }
}

Address::Address(const std::string ip, const uint16_t port)
{
  _ip = ip;
  _uiport = port;
}

Address::Address(const uint32_t ip)
{
  std::strstream str;

  str << (ip&0xff) << "." << ((ip>>8)&0xff) << "." << ((ip>>16)&0xff)
      << "." << ((ip>>24)&0xff) << ends;

  _ip = str.str();
  _uiport = 0;
  
  str.freeze(false);
}

Address::Address(const uint32_t ip, const uint16_t port)
{
  std::strstream str;

  str << (ip&0xff) << "." << ((ip>>8)&0xff) << "." << ((ip>>16)&0xff)
      << "." << ((ip>>24)&0xff) << ends;

  _ip = str.str();
  _uiport = port;

  str.freeze(false);
}

std::string Address::strIP()
{
  return _ip;
}

const uint32_t Address::longIP()
{
  std::string::size_type  idx;
  std::string             ip = _ip;
  uint32_t                lip = 0;
  int                     shift = 0;

  while( (idx = ip.find(".")) != std::string::npos )
    {
      std::strstream str;
      int       i;
      str << ip.substr(0, idx) << ends;
      str >> i;
      lip |= (i<<shift);
      shift += 8;
      ip = ip.substr(idx+1);
    }

  std::strstream str;
  int       i;
  str << ip;
  str >> i;
  lip |= i<<shift;

  return lip;
}

void Address::setPort(const uint16_t port)
{
  _uiport = port;
}

void Address::setPort(const std::string port)
{
  std::strstream str;
  str << port << ends;
  str >> _uiport;
}

void Address::setIP(const std::string ip)
{
  _ip = ip;
}

const uint16_t Address::port()
{
  return _uiport;
}

std::string Address::toString()
{
  std::strstream str;

  str << _ip << ":";
  str << _uiport << std::ends;

  std::string s;
  str >> s;

  return s;
}

std::string Address::strPort()
{
  std::strstream str;
  str << _uiport << std::ends;

  std::string s = str.str();
  str.freeze(false);

  return s;
}


bool Address::isPrivate()
{
  uint32_t ip = longIP();

  // 10.0.0.0/8
  // 172.16.0.0/12
  // 192.168.0.0/16
  // 127.0.0.0/8

  if(!ip) return true;

  return ( ((ip&0x000000ff)==0x0000000a) || ((ip&0x0000ffff)==0x0000a8c0) || ((ip&0x0000ffff)==0x000010ac) 
	   || ((ip&0x0000007f==0x0000007f)) );
}
