#include "DownloadManager.h"

#include "qtimer.h"
#include "qlistview.h"
#include "qlabel.h"
#include "qspinbox.h"

#include "QueryHitEntry.h"
#include "QtellaSub.h"
#include "Download.h"
#include "Connections.h"
#include "StringManipulation.h"

#include <iomanip>
#include <iostream>
#include <strstream>

DownloadManager::DownloadManager(QtellaSub* parent)
  : _parent(parent)
{
  _update_timer = new QTimer(this);
  connect(_update_timer, SIGNAL(timeout()), this, SLOT(slotUpdate()));
  _update_timer->start(1000);
}


void DownloadManager::addDownload(QueryHitEntry &qhe, QListViewItem *item)
{
  Download *d = new Download(qhe, item, this);
  
  _downloads.push_back(d);
  if( numberOfDownloads() < _parent->ui_spinbox_maxdownloads->value() ) d->run();
}


void DownloadManager::updatePush(std::string data, QSocket* socket)
{
  std::vector<Download*>::iterator  pos = _downloads.begin();
  
  std::string s(data);
  s.erase(0, 4);                             // erase "GIV "
  std::string::size_type idx = s.find(":");  // find first ":"
  std::string s_index = s.substr(0, idx);    // s_index = index
  s.erase(0, idx+1);
  idx = s.find("/");                         // find "/"
  std::string id = s.substr(0, idx);         // id
  s.erase(0, idx+1);
  idx = s.find("\n");
  std::string file = s.substr(0, idx);       // filename

  int index;
  std::strstream str;
  str << s_index << std::ends;
  str >> index;

  for(pos; pos != _downloads.end(); ++pos)
    if( (*pos)->readState() == Download::dtPushed )
      {
	StringManipulation sid(Connections::toHex((*pos)->_qhe.id));
	StringManipulation mid(id);

	if( (sid.to_lower()==mid.to_lower()) && (index==(*pos)->_qhe.index) && (file==(*pos)->_qhe.filename) )
	  (*pos)->startPushedDownload(socket);
      }
}


void DownloadManager::slotClearInactive()
{
  std::vector<Download*>::iterator  pos;

  for(pos = _downloads.begin(); pos != _downloads.end(); )
    if( ! (*pos)->isActive() )
      {
	delete *pos;
	pos = _downloads.erase(pos);
      }
    else
      ++pos;
}


void DownloadManager::slotRemoveDownload()
{
  std::vector<Download*>::iterator  pos;

  for(pos = _downloads.begin(); pos != _downloads.end(); )
    if( (*pos)->_item->isSelected() )
      {
	delete *pos;
	pos = _downloads.erase(pos);
      }
    else
      ++pos;
}


void DownloadManager::slotResumeDownload()
{
  int i;

  for(i = 0; i < _downloads.size(); i++)
    if( _downloads[i]->_item->isSelected() ) _downloads[i]->resumeDownload();
}


void DownloadManager::slotAbortDownload()
{
  int i;

  for(i = 0; i < _downloads.size(); i++)
    if( _downloads[i]->_item->isSelected() ) _downloads[i]->abortDownload();
}


void DownloadManager::slotUpdate()
{
  double bandwidth = 0;

  for(int i = 0; i < _downloads.size(); i++)
    {
      _downloads[i]->slotUpdateStatus();

      if(_downloads[i]->readState() == Download::dtConnected)
	bandwidth += _downloads[i]->readBandwidth();
      else
	if(_downloads[i]->readState() == Download::dtQueued)
	  if( numberOfDownloads() < _parent->ui_spinbox_maxdownloads->value() )
	    _downloads[i]->run();
    }

  std::strstream str;
  str.setf(ios::fixed);
  str << std::setprecision(2) << bandwidth << " KB/s" << std::ends;
  
  _parent->ui_textlabel_bandwidth->setText(str.str());
  str .freeze(false);
} 


int DownloadManager::numberOfDownloads()
{
  int n = 0;
  std::vector<Download*>::iterator  pos = _downloads.begin();

  for( pos; pos != _downloads.end(); ++pos )
    if( ((*pos)->readState() == Download::dtConnected) || ((*pos)->readState() == Download::dtConnecting) ||
	((*pos)->readState() == Download::dtPushed) )
      ++n;

  return n;
}
